/*
 * Decompiled with CFR 0.152.
 */
package murach.download;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import murach.business.User;
import murach.data.UserIO;

@WebServlet(name="DownloadServlet", description="Servlet to handle downloads", urlPatterns={"/download", "/error"})
public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String uri = request.getRequestURI();
        System.out.println("doGet from URI " + uri);
        System.out.println("doGet: action = " + request.getParameter("action"));
        System.out.println("doGet: productCode = " + request.getParameter("productCode"));
        String action = request.getParameter("action");
        if (action == null) {
            action = "viewAlbums";
        }
        String url = null;
        if (uri.equals("/error")) {
            int code = response.getStatus();
            System.out.println("in /error handler, code = " + code);
            request.setAttribute("error", (Object)("error forwarded from Spring, HTTP status code = " + code));
            url = "/error.jsp";
        } else if (action.equals("viewAlbums")) {
            url = "/index.html";
        } else if (action.equals("showProduct")) {
            url = this.showProduct(request, response);
        } else if (action.equals("viewCookies")) {
            url = "/view_cookies.jsp";
        } else if (action.equals("deleteCookies")) {
            url = this.deleteCookies(request, response);
        } else if (action.equals("logout")) {
            url = this.logout(request, response);
        } else if (action.equals("serveMp3")) {
            url = this.serveMp3(request, response);
        }
        if (url != null) {
            this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        System.out.println("doPost from URI " + request.getRequestURI());
        String action = request.getParameter("action");
        String url = "/index.jsp";
        if (action.equals("registerUser")) {
            url = this.registerUser(request, response);
        }
        System.out.println("doPost forwarding to " + url);
        this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
    }

    private String showProduct(HttpServletRequest request, HttpServletResponse response) {
        String productCode = request.getParameter("productCode");
        HttpSession session = request.getSession();
        String url = null;
        try {
            if (this.checkUser(request)) {
                url = this.determineProductView(request, productCode);
            } else {
                session.setAttribute("productCode", (Object)productCode);
                url = "/register.jsp";
            }
        }
        catch (IOException e) {
            request.setAttribute("error", (Object)("error accessing user: " + e));
            url = "/error.jsp";
        }
        return url;
    }

    private boolean checkUser(HttpServletRequest request) throws IOException {
        HttpSession session = request.getSession();
        User user = (User)session.getAttribute("user");
        return user != null;
    }

    private String registerUser(HttpServletRequest request, HttpServletResponse response) {
        String email = request.getParameter("email");
        String firstName = request.getParameter("firstName");
        String lastName = request.getParameter("lastName");
        String url = null;
        User user = new User();
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        ServletContext sc = this.getServletContext();
        String path = sc.getRealPath("/WEB-INF/EmailList.txt");
        try {
            UserIO.add(user, path);
        }
        catch (IOException e) {
            request.setAttribute("error", (Object)("error adding user: " + e));
            url = "/error.jsp";
            return url;
        }
        HttpSession session = request.getSession();
        session.setAttribute("user", (Object)user);
        Cookie c = new Cookie("emailCookie", email);
        c.setMaxAge(63072000);
        c.setPath("/");
        response.addCookie(c);
        String productCode = (String)session.getAttribute("productCode");
        url = this.determineProductView(request, productCode);
        return url;
    }

    String determineProductView(HttpServletRequest request, String productCode) {
        String url = null;
        if (productCode.equals("pf01")) {
            request.setAttribute("title", (Object)"Whiskey Before Breakfast");
            request.setAttribute("src", (Object)"download?productCode=pf01&amp;mp3Name=whiskey.mp3&amp;action=serveMp3");
            url = "/universal.jsp";
        } else {
            url = "/" + productCode + "_download.jsp";
            request.setAttribute("productCode", (Object)productCode);
        }
        return url;
    }

    private String serveMp3(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = null;
        String productCode = request.getParameter("productCode");
        String mp3Name = request.getParameter("mp3Name");
        if (productCode == null || mp3Name == null) {
            response.sendError(400);
            System.out.println("serveMp3 failing with 400");
            return null;
        }
        if (!this.checkUser(request)) {
            response.sendError(401);
            System.out.println("serveMp3 failing with 401");
            return null;
        }
        url = "/sound/" + productCode + "/" + mp3Name;
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher("default");
        System.out.println("rd = " + rd);
        RequestDispatcher rd1 = this.getServletContext().getRequestDispatcher(url);
        System.out.println("rd1 = " + rd1);
        if (rd == rd1) {
            System.out.println("RD for mp3 is default servlet RD");
        }
        System.out.println("serveMp3 forwarding to " + url);
        return url;
    }

    private String deleteCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = request.getCookies()) {
            cookie.setMaxAge(0);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        String url = "/delete_cookies.jsp";
        return url;
    }

    private String logout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().invalidate();
        return "/logout.jsp";
    }
}

