/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.presentation;

import cs636.music.domain.Cart;
import cs636.music.domain.Product;
import cs636.music.domain.Track;
import cs636.music.presentation.client.PresentationUtils;
import cs636.music.service.AdminService;
import cs636.music.service.ServiceException;
import cs636.music.service.UserService;
import cs636.music.service.data.DownloadData;
import cs636.music.service.data.InvoiceData;
import cs636.music.service.data.UserData;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;

public class SystemTest {
    private AdminService adminService;
    private UserService userService;
    private String inFile = "test.dat";
    private Cart cart;

    public SystemTest(AdminService admService, UserService usrService) {
        this.adminService = admService;
        this.userService = usrService;
    }

    public void runSystemTest() throws IOException, ServiceException {
        String command = null;
        System.out.println("starting SystemTest.run");
        Scanner in = new Scanner(this.getClass().getClassLoader().getResourceAsStream(this.inFile));
        while ((command = this.getNextCommand(in)) != null) {
            Object[] params;
            Product product;
            String productCode;
            UserData user;
            System.out.println("\n\n*************" + command + "***************\n");
            if (command.equalsIgnoreCase("i")) {
                System.out.println("Initializing system");
                this.adminService.initializeDB();
            } else if (command.equalsIgnoreCase("gp")) {
                Set<Product> cdList = this.userService.getProductList();
                if (cdList != null) {
                    PresentationUtils.displayCDCatlog(cdList, System.out);
                }
            } else if (command.startsWith("gui")) {
                String usr = this.getTokens(command)[1];
                user = this.userService.getUserInfo(usr);
                if (user == null) {
                    System.out.println("\nNo such user" + usr + "\n");
                } else {
                    PresentationUtils.displayUserInfo(user, System.out);
                }
            } else if (command.startsWith("gpi")) {
                productCode = this.getTokens(command)[1];
                product = this.userService.getProduct(productCode);
                if (product == null) {
                    System.out.println("\nNo such product\n");
                } else {
                    PresentationUtils.displayProductInfo(product, System.out);
                }
            } else if (command.startsWith("ureg")) {
                String[] userInfo = this.getTokens(command);
                System.out.println("Registering user: " + userInfo[1] + " " + userInfo[2] + " " + userInfo[3]);
                this.userService.registerUser(userInfo[1], userInfo[2], userInfo[3]);
            } else if (command.startsWith("gti")) {
                productCode = this.getTokens(command)[1];
                product = this.userService.getProduct(productCode);
                if (product == null) {
                    System.out.println("\nNo such product\n");
                } else {
                    PresentationUtils.displayTracks(product, System.out);
                }
            } else if (command.startsWith("dl")) {
                params = this.getTokens(command);
                String userEmail = params[1];
                String productCode2 = params[2];
                int tracknum = Integer.parseInt(params[3]);
                Product product2 = this.userService.getProduct(productCode2);
                if (product2 == null) {
                    System.out.println("\nNo such product\n");
                } else {
                    Set<Track> tracks = product2.getTracks();
                    UserData user2 = this.userService.getUserInfo(userEmail);
                    if (user2 == null) {
                        System.out.println("\nNo such user\n");
                    } else {
                        Track track0 = null;
                        for (Track track : tracks) {
                            if (track.getTrackNumber() != tracknum) continue;
                            track0 = track;
                        }
                        if (track0 != null) {
                            System.out.println("Recording download for user");
                            this.userService.addDownload(user2.getId(), track0);
                        } else {
                            System.out.println("\nNo such track\n");
                        }
                    }
                }
            } else if (command.startsWith("cc")) {
                this.cart = this.userService.createCart();
                System.out.println("\n cart created ");
            } else if (command.startsWith("sc")) {
                System.out.println("\n Now displaying Cart...");
                PresentationUtils.displayCart(this.cart, System.out);
            } else if (command.startsWith("co")) {
                params = this.getTokens(command);
                user = this.userService.getUserInfo(params[1]);
                if (user == null) {
                    System.out.println("\nNo such user\n");
                } else {
                    InvoiceData invoice = this.userService.checkout(this.cart, user.getId());
                    System.out.println("\n CDs Ordered...");
                    PresentationUtils.displayInvoice(invoice, System.out);
                    System.out.println();
                }
            } else if (command.startsWith("addli")) {
                params = this.getTokens(command);
                product = this.userService.getProduct(params[1]);
                if (product == null) {
                    System.out.println("\nNo such product\n");
                } else {
                    this.userService.addItemtoCart(product, this.cart, 1);
                    System.out.println("\n Added to Cart..");
                }
            } else if (command.startsWith("setproc")) {
                params = this.getIntTokens(command);
                this.adminService.processInvoice((long)params[1]);
            } else if (command.equalsIgnoreCase("gi")) {
                Set<InvoiceData> inv = this.adminService.getListofInvoices();
                PresentationUtils.displayInvoices(inv, System.out);
            } else if (command.startsWith("gd")) {
                Set<DownloadData> dList = this.adminService.getListofDownloads();
                PresentationUtils.downloadReport(dList, System.out);
            } else {
                System.out.println("Invalid Command: " + command);
            }
            System.out.println("----OK");
        }
        in.close();
    }

    public String getNextCommand(Scanner in) throws IOException {
        String line = null;
        try {
            line = in.nextLine();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return line != null ? line.trim() : line;
    }

    private String[] getTokens(String command) {
        return command.split("\\s+");
    }

    private int[] getIntTokens(String command) {
        String[] tokens = this.getTokens(command);
        int[] returnValue = new int[tokens.length];
        for (int i = 1; i < tokens.length; ++i) {
            returnValue[i] = Integer.parseInt(tokens[i]);
        }
        return returnValue;
    }
}

