/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DbDAO {
    @Autowired
    private DataSource dataSource;

    public void initializeDb(Connection connection) throws SQLException {
        this.clearTable(connection, "download");
        this.clearTable(connection, "lineitem");
        this.clearTable(connection, "invoice");
        this.clearTable(connection, "site_user");
        this.clearTable(connection, "music_sys_tab");
        this.initSysTable(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable(Connection connection, String tableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("delete from " + tableName);
        }
    }

    private void initSysTable(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("insert into music_sys_tab values (1,1,1,1)");
        }
    }

    public Connection startTransaction() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    public void commitTransaction(Connection connection) throws SQLException {
        connection.commit();
        connection.close();
    }

    public void rollbackTransaction(Connection connection) throws SQLException {
        connection.rollback();
        connection.close();
    }

    public void rollbackAfterException(Connection connection) {
        try {
            this.rollbackTransaction(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

