/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.dao;

import cs636.music.dao.LineItemDAO;
import cs636.music.dao.ProductDAO;
import cs636.music.dao.UserDAO;
import cs636.music.domain.Invoice;
import cs636.music.domain.LineItem;
import cs636.music.domain.Product;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class InvoiceDAO {
    @Autowired
    private UserDAO userdb;
    @Autowired
    private LineItemDAO lineitemdb;
    private ProductDAO proddb;

    public InvoiceDAO(LineItemDAO linedb, UserDAO udb, ProductDAO prddb) {
        this.lineitemdb = linedb;
        this.userdb = udb;
        this.proddb = prddb;
    }

    private void advanceInvoiceID(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(" update music_sys_tab set invoice_id = invoice_id + 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextInvoiceID(Connection connection) throws SQLException {
        int nextIID;
        try (Statement stmt = connection.createStatement();){
            ResultSet set = stmt.executeQuery(" select invoice_id from music_sys_tab");
            set.next();
            nextIID = set.getInt("invoice_id");
        }
        this.advanceInvoiceID(connection);
        return nextIID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertInvoice(Connection connection, Invoice invoice) throws SQLException {
        Statement stmt = connection.createStatement();
        int invoiceID = this.getNextInvoiceID(connection);
        invoice.setInvoiceId(invoiceID);
        String YN = "";
        YN = invoice.isProcessed() ? "y" : "n";
        try {
            String sqlString = "insert into invoice values (" + invoiceID + ", " + invoice.getUser().getId() + " , current_timestamp, " + invoice.getTotalAmount().toPlainString() + ", '" + YN + "')";
            stmt.execute(sqlString);
            for (LineItem item : invoice.getLineItems()) {
                this.lineitemdb.insertLineItem(connection, invoiceID, item);
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invoice findInvoice(Connection connection, long invoiceId) throws SQLException {
        Invoice invoice = null;
        try (Statement stmt = connection.createStatement();){
            String sqlString = " select * from invoice i, lineitem l  where i.invoice_id = " + invoiceId + " and i.invoice_id = l.invoice_id ";
            ResultSet set = stmt.executeQuery(sqlString);
            if (set.next()) {
                invoice = new Invoice(set.getInt("invoice_id"), this.userdb.findUserByID(connection, set.getInt("user_id")), set.getTimestamp("invoice_date"), set.getString("is_processed").equalsIgnoreCase("y"), null, set.getBigDecimal("total_amount"));
                HashSet<LineItem> items = new HashSet<LineItem>();
                Product product = this.proddb.findProductByPID(connection, set.getInt("product_id"));
                LineItem item = new LineItem(set.getInt("lineitem_id"), product, invoice, set.getInt("quantity"));
                items.add(item);
                while (set.next()) {
                    item = new LineItem(set.getInt("lineitem_id"), product, invoice, set.getInt("quantity"));
                    items.add(item);
                }
                invoice.setLineItems(items);
            }
            set.close();
        }
        return invoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Invoice> findAllUnprocessedInvoices(Connection connection) throws SQLException {
        HashSet<Invoice> invoices = new HashSet<Invoice>();
        String sqlString = " select invoice_id from invoice where is_processed = 'n'";
        try (Statement stmt = connection.createStatement();){
            ResultSet set = stmt.executeQuery(sqlString);
            while (set.next()) {
                Invoice invoice = this.findInvoice(connection, set.getInt("invoice_id"));
                invoices.add(invoice);
            }
            set.close();
        }
        return invoices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Invoice> findAllInvoices(Connection connection) throws SQLException {
        HashSet<Invoice> invoices = new HashSet<Invoice>();
        String sqlString = " select invoice_id from invoice";
        try (Statement stmt = connection.createStatement();){
            ResultSet set = stmt.executeQuery(sqlString);
            while (set.next()) {
                Invoice invoice = this.findInvoice(connection, set.getInt("invoice_id"));
                invoices.add(invoice);
            }
            set.close();
        }
        return invoices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInvoice(Connection connection, Invoice i) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sqlString = "update invoice set is_processed = 'y' where invoice_id = " + i.getInvoiceId();
            stmt.execute(sqlString);
        }
    }
}

