/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.presentation.web;

import cs636.music.config.MusicSystemConfig;
import cs636.music.service.AdminService;
import cs636.music.service.ServiceException;
import cs636.music.service.data.DownloadData;
import cs636.music.service.data.InvoiceData;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdminController {
    @Autowired
    private AdminService adminService;
    private static final String ADMIN_BASE_URL = "/adminController/";
    private static final String ADMIN_JSP_DIR = "/WEB-INF/admin/";
    private static final String ADMIN_ERROR_VIEW = "/WEB-INF/admin/error";
    private static final String ADMIN_WELCOME_URL = "/adminController/adminWelcome.html";
    private static final String ADMIN_MENU_VIEW = "/WEB-INF/admin/adminMenu";
    private static final String ADMIN_LOGIN_VIEW = "/WEB-INF/admin/adminLogin";
    private static final String ADMIN_LISTVARS_URL = "/adminController/listVariables.html";
    private static final String ADMIN_LISTVARS_VIEW = "/WEB-INF/admin/listVariables";
    private static final String ADMIN_LOGOUT_URL = "/adminController/logout.html";
    private static final String ADMIN_LOGOUT_VIEW = "/WEB-INF/admin/logout";
    private static final String ADMIN_INIT_DB_URL = "/adminController/initDB.html";
    private static final String ADMIN_INIT_DB_VIEW = "/WEB-INF/admin/initDB";
    private static final String ADMIN_PROCESS_INVOICES_URL = "/adminController/processInvoices.html";
    private static final String ADMIN_PENDING_INVOICES_VIEW = "/WEB-INF/admin/pendingInvoices";
    private static final String ADMIN_PROCESS_INVOICE_URL = "/adminController/processInvoice.html";
    private static final String ADMIN_DISPLAY_REPORTS_URL = "/adminController/displayReports.html";
    private static final String ADMIN_DISPLAY_REPORTS_VIEW = "/WEB-INF/admin/displayReports";

    @RequestMapping(value={"/adminController/adminWelcome.html"})
    public String handleAdminLogin(Model model, @RequestParam(required=false) String username, @RequestParam(required=false) String password, HttpServletRequest request) throws ServletException {
        String uname = (String)request.getSession().getAttribute("adminUser");
        if (uname != null) {
            return ADMIN_MENU_VIEW;
        }
        if (username != null && password != null) {
            try {
                System.out.println("calling checkLogin...");
                Boolean adminExistence = this.adminService.checkLogin(username, password);
                if (adminExistence.booleanValue()) {
                    request.getSession().setAttribute("adminUser", (Object)username);
                    return ADMIN_MENU_VIEW;
                }
                request.setAttribute("error", (Object)"Invalid Credentials");
                return ADMIN_LOGIN_VIEW;
            }
            catch (ServiceException e) {
                System.out.println("error: " + e);
                String error = "Error in checking credentials: " + e;
                request.setAttribute("error", (Object)error);
                return ADMIN_ERROR_VIEW;
            }
        }
        return ADMIN_LOGIN_VIEW;
    }

    @RequestMapping(value={"/adminController/listVariables.html"})
    public String listVariables(Model model) {
        String url = ADMIN_LISTVARS_VIEW;
        return url;
    }

    @RequestMapping(value={"/adminController/logout.html"})
    public String logout(Model model, HttpServletRequest request) {
        request.getSession().invalidate();
        String url = ADMIN_LOGOUT_VIEW;
        return url;
    }

    @RequestMapping(value={"/adminController/initDB.html"})
    public String initializeDB(Model model, HttpServletRequest request) throws ServletException {
        if (!this.checkAdmin(request)) {
            return "forward:/adminController/adminWelcome.html";
        }
        String info = null;
        try {
            this.adminService.initializeDB();
            info = "success";
        }
        catch (ServiceException e) {
            info = "failed: " + MusicSystemConfig.exceptionReport(e);
        }
        model.addAttribute("info", (Object)info);
        String url = ADMIN_INIT_DB_VIEW;
        return url;
    }

    @RequestMapping(value={"/adminController/processInvoices.html"})
    public String processInvoices(Model model, HttpServletRequest request) throws ServletException {
        if (!this.checkAdmin(request)) {
            return "forward:/adminController/adminWelcome.html";
        }
        String url = null;
        try {
            Set<InvoiceData> pendingInvoices = this.adminService.getListofUnprocessedInvoices();
            model.addAttribute("unProcessedInvoices", pendingInvoices);
            System.out.println("#pendingInvoices: " + pendingInvoices.size());
            return ADMIN_PENDING_INVOICES_VIEW;
        }
        catch (ServiceException e) {
            String error = "Error: " + e;
            model.addAttribute("error", (Object)error);
            url = ADMIN_ERROR_VIEW;
            return url;
        }
    }

    @RequestMapping(value={"/adminController/processInvoice.html"})
    public String processInvoice(Model model, @RequestParam long invoiceId, HttpServletRequest request) throws ServletException {
        if (!this.checkAdmin(request)) {
            return "forward:/adminController/adminWelcome.html";
        }
        String error = null;
        System.out.println(" Processing invoice " + invoiceId + " .....");
        try {
            this.adminService.processInvoice(invoiceId);
        }
        catch (ServiceException e) {
            error = "Error: " + e;
            model.addAttribute("error", (Object)error);
            return ADMIN_ERROR_VIEW;
        }
        return "forward:/adminController/processInvoices.html";
    }

    @RequestMapping(value={"/adminController/displayReports.html"})
    public String displayReports(Model model, HttpServletRequest request) throws ServletException {
        if (!this.checkAdmin(request)) {
            return "forward:/adminController/adminWelcome.html";
        }
        String url = null;
        String error = null;
        try {
            Set<DownloadData> downloadReport = this.adminService.getListofDownloads();
            model.addAttribute("downloads", downloadReport);
            Set<InvoiceData> invoiceReport = this.adminService.getListofInvoices();
            model.addAttribute("invoices", invoiceReport);
            url = ADMIN_DISPLAY_REPORTS_VIEW;
        }
        catch (ServiceException e) {
            error = "Error: " + e;
            model.addAttribute("error", (Object)error);
            url = ADMIN_ERROR_VIEW;
        }
        return url;
    }

    private boolean checkAdmin(HttpServletRequest request) {
        boolean isAdmin = request.getSession().getAttribute("adminUser") != null;
        return isAdmin;
    }
}

