/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.presentation.client;

import cs636.music.presentation.client.PresentationUtils;
import cs636.music.service.AdminService;
import cs636.music.service.ServiceException;
import cs636.music.service.data.InvoiceData;
import java.io.IOException;
import java.util.Scanner;
import java.util.Set;

public class AdminApp {
    private AdminService adminService;
    private Scanner in;

    public AdminApp(AdminService adminService) {
        this.adminService = adminService;
        this.in = new Scanner(System.in);
    }

    public void loginPage() throws IOException, ServiceException {
        System.out.println("---Login Page---");
        String username = PresentationUtils.readEntry(this.in, "User Name _ ");
        String password = PresentationUtils.readEntry(this.in, "Password _ ");
        if (this.adminService.checkLogin(username, password).booleanValue()) {
            this.handleMainPage();
        } else {
            System.out.println(" User name and password did not match !!");
        }
    }

    public void handleMainPage() throws IOException, ServiceException {
        String command = null;
        while (true) {
            System.out.println("---Main Page---");
            System.out.println(" P: Process Invoice ");
            System.out.println(" R: Display Report ");
            System.out.println(" I: Initialize Database ");
            System.out.println(" Q: Quit ");
            command = PresentationUtils.readEntry(this.in, "Please Enter the Command");
            if (command.equalsIgnoreCase("P")) {
                this.processInvoice();
                continue;
            }
            if (command.equalsIgnoreCase("R")) {
                this.displayReports();
                continue;
            }
            if (command.equalsIgnoreCase("I")) {
                this.adminService.initializeDB();
                continue;
            }
            if (command.equalsIgnoreCase("Q")) {
                return;
            }
            System.out.println("Invalid Command! Try again...");
        }
    }

    public void processInvoice() throws IOException, ServiceException {
        String command = null;
        while (true) {
            System.out.println("---Process Invoice Page---");
            Set<InvoiceData> invoices = this.adminService.getListofUnprocessedInvoices();
            if (invoices.isEmpty()) {
                System.out.println("No unprocessed invoices exist, returning to main page");
                return;
            }
            PresentationUtils.displayInvoices(this.adminService.getListofUnprocessedInvoices(), System.out);
            System.out.println(" I: Choose Invoice to Process");
            System.out.println(" B: Back to Main Page ");
            command = PresentationUtils.readEntry(this.in, "Please Enter the Command");
            if (command.equalsIgnoreCase("I")) {
                int invoice_id = Integer.parseInt(PresentationUtils.readEntry(this.in, "invoice id"));
                System.out.println(" Processing invoice " + invoice_id + " .....");
                this.adminService.processInvoice(invoice_id);
                continue;
            }
            if (command.equalsIgnoreCase("B")) {
                return;
            }
            System.out.println("Invalid Command! Try again...");
        }
    }

    public void displayReports() throws IOException, ServiceException {
        String command = null;
        while (true) {
            System.out.println("---Display Reports Page---");
            System.out.println(" I: List of All Invoices To Process");
            System.out.println(" D: List of All Downloads");
            System.out.println(" B: Back to Main Page ");
            command = PresentationUtils.readEntry(this.in, "Please Enter the Command");
            if (command.equalsIgnoreCase("I")) {
                PresentationUtils.displayInvoices(this.adminService.getListofInvoices(), System.out);
                continue;
            }
            if (command.equalsIgnoreCase("D")) {
                PresentationUtils.downloadReport(this.adminService.getListofDownloads(), System.out);
                continue;
            }
            if (command.equalsIgnoreCase("B")) {
                return;
            }
            System.out.println("Invalid Command! Try again...");
        }
    }
}

