/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.presentation.client;

import cs636.music.domain.Cart;
import cs636.music.domain.Product;
import cs636.music.domain.Track;
import cs636.music.presentation.client.PresentationUtils;
import cs636.music.service.ServiceException;
import cs636.music.service.UserService;
import cs636.music.service.data.InvoiceData;
import cs636.music.service.data.UserData;
import java.io.IOException;
import java.util.Scanner;
import java.util.Set;

public class UserApp {
    private UserService userService;
    private Scanner in;
    private UserData user = null;
    private Cart cart = null;

    public void handleCatalogPage() throws IOException, ServiceException {
        Product prod = null;
        while (true) {
            System.out.println("---Catalog Page---");
            Set<Product> prodlist = this.userService.getProductList();
            System.out.println("Displaying list of CDs: product codes and descriptions");
            PresentationUtils.displayCDCatlog(prodlist, System.out);
            String productCode = PresentationUtils.readEntry(this.in, "Enter the product code of product to see info, or S to show cart or Q to quit");
            if (productCode.equalsIgnoreCase("S")) {
                if (this.cart == null) {
                    this.cart = this.userService.createCart();
                }
                this.handleCartPage(null);
                continue;
            }
            if (productCode.equalsIgnoreCase("Q")) {
                return;
            }
            prod = this.userService.getProduct(productCode);
            if (prod != null) {
                this.handleProduct(prod);
                continue;
            }
            System.out.println(" Can't find the product: " + productCode + " !!!");
        }
    }

    public void handleProduct(Product product) throws IOException, ServiceException {
        boolean listening = false;
        while (true) {
            if (listening) {
                System.out.println("---Sound Page---");
                System.out.println(" Displaying list of tracks: track# and title");
                PresentationUtils.displayTracks(product, System.out);
            } else {
                System.out.println("---Product Page--");
                System.out.println("displaying product info for this product");
                PresentationUtils.displayProductInfo(product, System.out);
            }
            String command = null;
            if (this.cart == null) {
                this.cart = this.userService.createCart();
            }
            System.out.println("Possible Commands");
            if (listening) {
                System.out.println("T: Track# to play");
            }
            System.out.println("A: Add CD to Cart");
            System.out.println("S: Show Cart - has other options like CheckOut");
            if (!listening) {
                System.out.println("L: Listen to Sample ");
            }
            System.out.println("B: Browse Catalog");
            command = PresentationUtils.readEntry(this.in, "Please Enter the Command");
            if (command.equalsIgnoreCase("A")) {
                this.handleCartPage(product);
                return;
            }
            if (command.equalsIgnoreCase("S")) {
                this.handleCartPage(null);
                return;
            }
            if (command.equalsIgnoreCase("L") && !listening) {
                if (this.user == null) {
                    this.user = this.userUI();
                }
                listening = true;
                continue;
            }
            if (command.equalsIgnoreCase("T") && listening) {
                String trackNumberString = PresentationUtils.readEntry(this.in, "Please enter track# to download & play");
                int trackNumber = Integer.parseInt(trackNumberString);
                System.out.println("getting Track " + trackNumber + ", recording download and fake-playing track");
                Track track = product.findTrackbyNumber(trackNumber);
                if (track != null) {
                    PresentationUtils.playTrack(track, System.out);
                    this.userService.addDownload(this.user.getId(), track);
                    continue;
                }
                System.out.println("Can't find track #" + trackNumber);
                continue;
            }
            if (command.equalsIgnoreCase("B")) {
                return;
            }
            System.out.println("Invalid Command: " + command + "! Try again...");
        }
    }

    public void handleCartPage(Product newProduct) throws IOException, ServiceException {
        System.out.println("---Cart Page---");
        if (newProduct != null) {
            this.userService.addItemtoCart(newProduct, this.cart, 1);
        }
        while (true) {
            String productCode;
            System.out.println("displaying Cart");
            PresentationUtils.displayCart(this.cart, System.out);
            System.out.println("Possible Commands");
            System.out.println("C: Change to Cart");
            System.out.println("R: Remove from Cart ");
            System.out.println("O: Check Out ");
            System.out.println("B: Browse Catalog");
            String command = PresentationUtils.readEntry(this.in, "Please Enter the Command");
            if (command.equalsIgnoreCase("C")) {
                productCode = PresentationUtils.readEntry(this.in, "Enter the product code of product to change");
                int quantity = Integer.parseInt(PresentationUtils.readEntry(this.in, "Enter the new quantity of the product"));
                Product prd = this.userService.getProduct(productCode);
                if (prd == null) {
                    System.out.println(" Can't find the product: " + productCode + " !!!");
                    continue;
                }
                this.userService.changeCart(prd, this.cart, quantity);
                continue;
            }
            if (command.equalsIgnoreCase("R")) {
                productCode = PresentationUtils.readEntry(this.in, "Enter the product code for removal");
                Product prd = this.userService.getProduct(productCode);
                if (prd == null) {
                    System.out.println(" Can't find the product: " + productCode + " !!!");
                    continue;
                }
                this.userService.removeCartItem(prd, this.cart);
                continue;
            }
            if (command.equalsIgnoreCase("O")) {
                this.handleCheckOut();
                return;
            }
            if (command.equalsIgnoreCase("B")) {
                return;
            }
            System.out.println("Invalid Command!");
        }
    }

    public void handleCheckOut() throws IOException, ServiceException {
        if (this.cart.getItems().size() > 0) {
            System.out.println("---CheckOut Page---");
            if (this.user == null) {
                this.user = this.userUI();
            }
            System.out.println("\nCreating order for:");
            System.out.println("displaying Cart");
            PresentationUtils.displayCart(this.cart, System.out);
            InvoiceData newInvoice = this.userService.checkout(this.cart, this.user.getId());
            System.out.println("\nThank you for your order, your cart is now empty.\n");
            PresentationUtils.displayInvoice(newInvoice, System.out);
        } else {
            System.out.println("The cart is empty!!");
        }
    }

    public UserData userUI() throws IOException, ServiceException {
        System.out.println("---User Registration Page---");
        String fName = PresentationUtils.readEntry(this.in, "\n Give us a few registration details:\n\t\t FirstName");
        String lName = PresentationUtils.readEntry(this.in, "\n\t\t LastName");
        String eMail = PresentationUtils.readEntry(this.in, "\n\t\t Email");
        this.userService.registerUser(fName, lName, eMail);
        UserData user = this.userService.getUserInfo(eMail);
        PresentationUtils.displayUserInfo(user, System.out);
        return user;
    }
}

