/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.presentation.web;

import cs636.music.domain.Cart;
import cs636.music.presentation.web.UserBean;
import cs636.music.service.ServiceException;
import cs636.music.service.UserService;
import cs636.music.service.data.InvoiceData;
import cs636.music.service.data.UserData;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class UserController {
    @Autowired
    private UserService userService;
    private static final String WELCOME_URL = "/welcome.html";
    private static final String WELCOME_VIEW = "/welcome";
    private static final String USER_WELCOME_URL = "/userWelcome.html";
    private static final String USER_WELCOME_VIEW = "/WEB-INF/jsp/userWelcome";
    private static final String CATALOG_URL = "/catalog.html";
    private static final String CATALOG_VIEW = "/WEB-INF/jsp/catalog";
    private static final String CART_URL = "/cart.html";
    private static final String CART_VIEW = "/WEB-INF/jsp/cart";
    private static final String PRODUCT_URL = "/product.html";
    private static final String PRODUCT_VIEW = "/WEB-INF/jsp/product";
    private static final String REGISTER_URL = "/register.html";
    private static final String LISTEN_URL = "/listen.html";
    private static final String SOUND_VIEW = "/WEB-INF/jsp/sound";
    private static final String REGISTER_FORM_VIEW = "/WEB-INF/jsp/registerForm";
    private static final String DOWNLOAD_URL = "/download.html";
    private static final String BEGIN_CHECKOUT_URL = "/beginCheckout.html";
    private static final String CHECKOUT_URL = "/checkout.html";
    private static final String INVOICE_VIEW = "/WEB-INF/jsp/invoice";

    @RequestMapping(value={"/welcome.html"})
    public String handleWelcome() {
        return WELCOME_VIEW;
    }

    @RequestMapping(value={"/register.html"})
    public String register(@RequestParam String firstName, @RequestParam String lastName, @RequestParam String email, HttpServletRequest request) throws ServletException {
        if (!this.checkUser(request)) {
            return "forward:/userWelcome.html";
        }
        HttpSession session = request.getSession();
        UserBean userBean = (UserBean)session.getAttribute("user");
        UserData user = userBean.getUser();
        if (user == null) {
            try {
                this.userService.registerUser(firstName, lastName, email);
                user = this.userService.getUserInfo(email);
                userBean.setUser(user);
                System.out.println("user registered");
            }
            catch (ServiceException e) {
                System.out.println("Listen handler: " + e);
                throw new ServletException((Throwable)e);
            }
        }
        boolean doingCheckout = userBean.isDoingCheckout();
        System.out.println("Returning from Register handler");
        return doingCheckout ? "forward:/checkout.html" : "forward:/listen.html";
    }

    @RequestMapping(value={"/beginCheckout.html"})
    public String beginCheckout(HttpServletRequest request) throws ServletException {
        if (!this.checkUser(request)) {
            return "forward:/userWelcome.html";
        }
        HttpSession session = request.getSession();
        UserBean userBean = (UserBean)session.getAttribute("user");
        userBean.setDoingCheckout(true);
        UserData user = userBean.getUser();
        System.out.println("Returning from BeginCheckoutController");
        return user != null ? "forward:/checkout.html" : REGISTER_FORM_VIEW;
    }

    @RequestMapping(value={"/checkout.html"})
    public String checkout(HttpServletRequest request) throws ServletException {
        if (!this.checkUser(request)) {
            return "forward:/userWelcome.html";
        }
        HttpSession session = request.getSession();
        UserBean userBean = (UserBean)session.getAttribute("user");
        userBean.setDoingCheckout(false);
        Cart userCart = userBean.getCart();
        UserData user = userBean.getUser();
        assert (user != null);
        InvoiceData invoice = null;
        try {
            invoice = this.userService.checkout(userCart, user.getId());
        }
        catch (ServiceException e) {
            System.out.println("Checkout handler: " + e);
            throw new ServletException((Throwable)e);
        }
        request.setAttribute("invoice", (Object)invoice);
        session.setAttribute("user", (Object)userBean);
        return INVOICE_VIEW;
    }

    private boolean checkUser(HttpServletRequest request) {
        boolean hasBean;
        System.out.print("checkUser: ");
        boolean bl = hasBean = request.getSession().getAttribute("user") != null;
        if (hasBean) {
            UserBean bean = (UserBean)request.getSession().getAttribute("user");
            if (bean.getUser() == null) {
                System.out.println("user bean has no user yet");
            } else {
                System.out.println("user bean's user:" + bean.getUser().getEmailAddress());
            }
            if (bean.getCart() == null) {
                System.out.println("user bean has no cart yes");
            } else {
                System.out.println("user bean's cart itemcount = " + bean.getCart().getItems().size());
            }
        } else {
            System.out.println("no user bean in session");
        }
        return hasBean;
    }
}

