/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.service;

import cs636.music.dao.AdminDAO;
import cs636.music.dao.DbDAO;
import cs636.music.dao.DownloadDAO;
import cs636.music.dao.InvoiceDAO;
import cs636.music.domain.Download;
import cs636.music.domain.Invoice;
import cs636.music.service.ServiceException;
import cs636.music.service.data.DownloadData;
import cs636.music.service.data.InvoiceData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminService {
    @Autowired
    private DbDAO db;
    @Autowired
    private DownloadDAO downloadDb;
    @Autowired
    private InvoiceDAO invoiceDb;
    @Autowired
    private AdminDAO adminDb;

    public void initializeDB() throws ServiceException {
        Connection connection = null;
        try {
            connection = this.db.startTransaction();
            this.db.initializeDb(connection);
            this.db.commitTransaction(connection);
        }
        catch (Exception e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't initialize DB: (probably need to load DB)", e);
        }
    }

    public void processInvoice(long invoiceId) throws ServiceException {
        Connection connection = null;
        try {
            connection = this.db.startTransaction();
            Invoice i = this.invoiceDb.findInvoice(connection, invoiceId);
            this.invoiceDb.updateInvoice(connection, i);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't process invoice: ", e);
        }
    }

    public Set<InvoiceData> getListofInvoices() throws ServiceException {
        Connection connection = null;
        Set<Invoice> invoices = null;
        try {
            connection = this.db.startTransaction();
            invoices = this.invoiceDb.findAllInvoices(connection);
            this.db.commitTransaction(connection);
        }
        catch (Exception e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't find invoice list in DB: ", e);
        }
        HashSet<InvoiceData> invoices1 = new HashSet<InvoiceData>();
        for (Invoice i : invoices) {
            invoices1.add(new InvoiceData(i));
        }
        return invoices1;
    }

    public Set<InvoiceData> getListofUnprocessedInvoices() throws ServiceException {
        Connection connection = null;
        Set<Invoice> invoices = null;
        try {
            connection = this.db.startTransaction();
            invoices = this.invoiceDb.findAllUnprocessedInvoices(connection);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't find unprocessed invoice list in DB: ", e);
        }
        HashSet<InvoiceData> invoices1 = new HashSet<InvoiceData>();
        for (Invoice i : invoices) {
            invoices1.add(new InvoiceData(i));
        }
        return invoices1;
    }

    public Set<DownloadData> getListofDownloads() throws ServiceException {
        Connection connection = null;
        Set<Download> downloads = null;
        try {
            connection = this.db.startTransaction();
            downloads = this.downloadDb.findAllDownloads(connection);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't find download list: ", e);
        }
        HashSet<DownloadData> downloads1 = new HashSet<DownloadData>();
        for (Download d : downloads) {
            downloads1.add(new DownloadData(d));
        }
        return downloads1;
    }

    public Boolean checkLogin(String username, String password) throws ServiceException {
        Connection connection = null;
        try {
            connection = this.db.startTransaction();
            Boolean b = this.adminDb.findAdminUser(connection, username, password);
            this.db.commitTransaction(connection);
            return b;
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Check login error (SQL): " + e.getMessage(), e);
        }
    }
}

