/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.domain;

import cs636.music.domain.CartItem;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Cart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<CartItem> items = new HashSet<CartItem>();

    public Set<CartItem> getItems() {
        return this.items;
    }

    public CartItem findItem(String productCode) {
        for (CartItem i : this.items) {
            if (!i.getProductCode().equals(productCode)) continue;
            return i;
        }
        return null;
    }

    public void addItem(CartItem item) {
        if (this.items == null) {
            this.items = new HashSet<CartItem>();
        }
        String productCode = item.getProductCode();
        int quantity = item.getQuantity();
        for (CartItem i : this.items) {
            if (!i.getProductCode().equals(productCode)) continue;
            i.setQuantity(quantity);
            return;
        }
        this.items.add(item);
    }

    public void removeItem(String productCode) {
        for (CartItem i : this.items) {
            if (!i.getProductCode().equals(productCode)) continue;
            this.items.remove(i);
            return;
        }
    }

    public void clear() {
        this.items.clear();
    }
}

