/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.domain;

import cs636.music.domain.Track;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Product
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String code;
    private String description;
    private BigDecimal price;
    private Set<Track> tracks;

    public Product(long id, String code, String description, BigDecimal price, Set<Track> tracks) {
        this.id = id;
        this.code = code;
        this.description = description;
        this.price = price;
        this.tracks = tracks;
    }

    public Set<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(Set<Track> tracks) {
        this.tracks = tracks;
    }

    public Product() {
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCode() {
        return this.code;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Track findTrackbyNumber(int trackNumber) {
        for (Track track : this.tracks) {
            if (trackNumber != track.getTrackNumber()) continue;
            return track;
        }
        return null;
    }

    public Track findTrackbyID(int trackID) {
        for (Track track : this.tracks) {
            if ((long)trackID != track.getId()) continue;
            return track;
        }
        return null;
    }

    public List<Track> getOrderedTracks() {
        LinkedList<Track> ordTracks = new LinkedList<Track>();
        for (Track track : this.tracks) {
            ordTracks.add(track);
        }
        Collections.sort(ordTracks, Comparator.comparing(Track::getTrackNumber));
        return ordTracks;
    }
}

