/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.dao;

import cs636.music.dao.ProductDAO;
import cs636.music.dao.UserDAO;
import cs636.music.domain.Download;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DownloadDAO {
    @Autowired
    private ProductDAO proddb;
    @Autowired
    private UserDAO userdb;

    private void advanceDownloadID(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(" update music_sys_tab set download_id = download_id + 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextDownloadID(Connection connection) throws SQLException {
        int nextDID;
        try (Statement stmt = connection.createStatement();){
            ResultSet set = stmt.executeQuery(" select download_id from music_sys_tab");
            set.next();
            nextDID = set.getInt("download_id");
        }
        this.advanceDownloadID(connection);
        return nextDID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDownload(Connection connection, Download download) throws SQLException {
        Statement stmt = connection.createStatement();
        int download_id = this.getNextDownloadID(connection);
        download.setDownloadId(download_id);
        try {
            String sqlString = "insert into download values (" + download.getDownloadId() + ", " + download.getUser().getId() + ", current_timestamp, " + download.getTrack().getId() + ")";
            stmt.execute(sqlString);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Download> findAllDownloads(Connection connection) throws SQLException {
        Download download = null;
        HashSet<Download> downloads = new HashSet<Download>();
        String sqlString = "select * from download order by download_date";
        try (Statement stmt = connection.createStatement();){
            ResultSet set = stmt.executeQuery(sqlString);
            while (set.next()) {
                download = new Download();
                download.setDownloadId(set.getInt("download_id"));
                download.setDownloadDate(set.getTimestamp("download_date"));
                download.setUser(this.userdb.findUserByID(connection, set.getInt("user_id")));
                download.setTrack(this.proddb.findTrackByTID(connection, set.getInt("track_id")));
                downloads.add(download);
            }
        }
        return downloads;
    }
}

