/*
 * Decompiled with CFR 0.152.
 */
package cs636.music.service;

import cs636.music.dao.DbDAO;
import cs636.music.dao.DownloadDAO;
import cs636.music.dao.InvoiceDAO;
import cs636.music.dao.ProductDAO;
import cs636.music.dao.UserDAO;
import cs636.music.domain.Cart;
import cs636.music.domain.CartItem;
import cs636.music.domain.Download;
import cs636.music.domain.Invoice;
import cs636.music.domain.LineItem;
import cs636.music.domain.Product;
import cs636.music.domain.Track;
import cs636.music.domain.User;
import cs636.music.service.ServiceException;
import cs636.music.service.data.InvoiceData;
import cs636.music.service.data.UserData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Autowired
    private DownloadDAO downloadDb;
    @Autowired
    private InvoiceDAO invoiceDb;
    @Autowired
    private ProductDAO prodDb;
    @Autowired
    private UserDAO userDb;
    @Autowired
    private DbDAO db;

    public Set<Product> getProductList() throws ServiceException {
        Set<Product> prodlist;
        Connection connection = null;
        try {
            connection = this.db.startTransaction();
            prodlist = this.prodDb.findAllProducts(connection);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't find product list in db: ", e);
        }
        return prodlist;
    }

    public Cart createCart() {
        return new Cart();
    }

    public void addItemtoCart(Product prod, Cart cart, int quantity) {
        CartItem item = cart.findItem(prod.getCode());
        if (item != null) {
            int qty = item.getQuantity();
            item.setQuantity(qty + quantity);
        } else {
            item = new CartItem(prod.getCode(), quantity);
            cart.getItems().add(item);
        }
    }

    public void changeCart(Product prod, Cart cart, int quantity) {
        CartItem item = cart.findItem(prod.getCode());
        if (item != null) {
            if (quantity > 0) {
                item.setQuantity(quantity);
            } else {
                cart.removeItem(prod.getCode());
            }
        }
    }

    public void removeCartItem(Product prod, Cart cart) {
        CartItem item = cart.findItem(prod.getCode());
        if (item != null) {
            cart.removeItem(prod.getCode());
        }
    }

    public void registerUser(String firstname, String lastname, String email) throws ServiceException {
        Connection connection = null;
        User user = null;
        try {
            connection = this.db.startTransaction();
            user = this.userDb.findUserByEmail(connection, email);
            if (user == null) {
                user = new User();
                user.setFirstname(firstname);
                user.setLastname(lastname);
                user.setEmailAddress(email);
                this.userDb.insertUser(connection, user);
            }
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Error while registering user: ", e);
        }
    }

    public UserData getUserInfo(String email) throws ServiceException {
        Connection connection = null;
        User user = null;
        UserData user1 = null;
        try {
            connection = this.db.startTransaction();
            user = this.userDb.findUserByEmail(connection, email);
            user1 = new UserData(user);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Error while getting user info: ", e);
        }
        return user1;
    }

    public Product getProduct(String prodCode) throws ServiceException {
        Connection connection = null;
        Product prd = null;
        try {
            connection = this.db.startTransaction();
            prd = this.prodDb.findProductByCode(connection, prodCode);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Error while registering user: ", e);
        }
        return prd;
    }

    public InvoiceData checkout(Cart cart, long userId) throws ServiceException {
        Connection connection = null;
        Invoice invoice = null;
        try {
            connection = this.db.startTransaction();
            User user = this.userDb.findUserByID(connection, userId);
            invoice = new Invoice(-1L, user, new Date(), false, null, null);
            HashSet<LineItem> lineItems = new HashSet<LineItem>();
            for (CartItem item : cart.getItems()) {
                Product prod = this.prodDb.findProductByCode(connection, item.getProductCode());
                LineItem li = new LineItem(prod, invoice, item.getQuantity());
                lineItems.add(li);
            }
            invoice.setLineItems(lineItems);
            invoice.setTotalAmount(invoice.calculateTotal());
            this.invoiceDb.insertInvoice(connection, invoice);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't check out: ", e);
        }
        cart.clear();
        return new InvoiceData(invoice);
    }

    public void addDownload(long userId, Track track) throws ServiceException {
        Connection connection = null;
        try {
            connection = this.db.startTransaction();
            Download download = new Download();
            User user = this.userDb.findUserByID(connection, userId);
            download.setUser(user);
            download.setTrack(track);
            this.downloadDb.insertDownload(connection, download);
            this.db.commitTransaction(connection);
        }
        catch (SQLException e) {
            this.db.rollbackAfterException(connection);
            throw new ServiceException("Can't add download: ", e);
        }
    }
}

