/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation;

import cs636.pizza.config.PizzaSystemConfig;
import cs636.pizza.dao.DbDAO;
import cs636.pizza.presentation.ShopAdmin;
import cs636.pizza.presentation.SystemTest;
import cs636.pizza.presentation.TakeOrder;
import cs636.pizza.service.AdminService;
import cs636.pizza.service.StudentService;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ClientRun
implements CommandLineRunner {
    @Autowired
    private AdminService adminService;
    @Autowired
    private StudentService studentService;
    @Autowired
    Environment environment;
    @Autowired
    DbDAO dbDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String ... args) throws Exception {
        block9: {
            System.out.println("Starting ClientRun, #args = " + args.length);
            String dbUrl = null;
            String dbUser = null;
            String dbPassword = null;
            String app = "SystemTest";
            System.out.println("Starting ClientRun now, #args = " + args.length);
            for (String arg : args) {
                System.out.println("arg: " + arg);
            }
            if (args.length >= 1) {
                app = args[0];
            }
            if (args.length >= 4) {
                dbUrl = args[1];
                System.out.println("dbUrl1 = " + dbUrl);
                dbUser = args[2];
                dbPassword = args[3];
            }
            System.out.println("dbUrl2 = " + dbUrl);
            EntityManagerFactory emf = PizzaSystemConfig.configureJPA(dbUrl, dbUser, dbPassword);
            this.dbDAO.setEntityManagerFactory(emf);
            try {
                if (app.equals("SystemTest")) {
                    System.out.println("Starting SystemTest from ClientRun");
                    SystemTest st = new SystemTest(this.adminService, this.studentService);
                    st.runSystemTest();
                    break block9;
                }
                if (app.equals("ShopAdmin")) {
                    System.out.println("Starting ShopAdmin from ClientRun");
                    ShopAdmin sa = new ShopAdmin(this.adminService);
                    sa.runShopAdmin();
                    break block9;
                }
                if (app.equals("TakeOrder")) {
                    System.out.println("Starting TakeOrder from ClientRun");
                    TakeOrder ta = new TakeOrder(this.studentService);
                    ta.runTakeOrder();
                    break block9;
                }
                System.out.println("app = " + app + ", not SystemTest, ShopAdmin or TakeOrder, so not running one of them");
                return;
            }
            finally {
                this.dbDAO.shutdown();
            }
        }
    }
}

