/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.service;

import cs636.pizza.dao.AdminDAO;
import cs636.pizza.dao.DbDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.dao.PizzaOrderDAO;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminService {
    @Autowired
    private DbDAO dbDAO;
    @Autowired
    private AdminDAO adminDAO;
    @Autowired
    private MenuDAO menuDAO;
    @Autowired
    private PizzaOrderDAO pizzaOrderDAO;

    public void initializeDb() throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            this.dbDAO.initializeDb();
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Can't initialize DB: (probably need to load DB)", e);
        }
    }

    public void addTopping(String name) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            this.menuDAO.createMenuTopping(name);
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Topping was not added successfully: ", e);
        }
    }

    public void removeTopping(String topping) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            this.menuDAO.deleteMenuTopping(topping);
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error while removing topping ", e);
        }
    }

    public void addPizzaSize(String name) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            this.menuDAO.createMenuSize(name);
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Pizza size was not added successfully", e);
        }
    }

    public void removePizzaSize(String size) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            this.menuDAO.deleteMenuSize(size);
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error while removing topping", e);
        }
    }

    public void markNextOrderReady() throws ServiceException {
        PizzaOrder order = null;
        try {
            this.dbDAO.startTransaction();
            order = this.pizzaOrderDAO.findFirstOrder(1);
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error in marking the next order ready", e);
        }
        if (order == null) {
            throw new ServiceException("No PREPARING orders exist!");
        }
        order.makeReady();
        try {
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error at commit in marking the next order ready", e);
        }
    }

    public int getCurrentDay() throws ServiceException {
        int day;
        try {
            this.dbDAO.startTransaction();
            day = this.adminDAO.findCurrentDay();
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Can't access date in db: ", e);
        }
        return day;
    }

    public void advanceDay() throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            List<PizzaOrder> pizzaOrders = this.getTodaysOrders();
            for (PizzaOrder order : pizzaOrders) {
                order.finish();
            }
            this.adminDAO.advanceDay();
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Unsuccessful advance day", e);
        }
    }

    private List<PizzaOrder> getTodaysOrders() {
        int today = this.adminDAO.findCurrentDay();
        List<PizzaOrder> orders = this.pizzaOrderDAO.findOrdersByDays(today, today);
        return orders;
    }

    public List<PizzaOrderData> getOrdersByDay(int day) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            List<PizzaOrder> orders = this.pizzaOrderDAO.findOrdersByDays(day, day);
            ArrayList<PizzaOrderData> orders1 = new ArrayList<PizzaOrderData>();
            for (PizzaOrder o : orders) {
                orders1.add(new PizzaOrderData(o));
            }
            this.dbDAO.commitTransaction();
            return orders1;
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error while getting daily report ", e);
        }
    }

    public List<PizzaOrderData> getTodaysOrdersByStatus(int status) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            List<PizzaOrder> orders = this.getTodaysOrders();
            ArrayList<PizzaOrderData> orders1 = new ArrayList<PizzaOrderData>();
            for (PizzaOrder o : orders) {
                if (o.getStatus() != status) continue;
                orders1.add(new PizzaOrderData(o));
            }
            this.dbDAO.commitTransaction();
            return orders1;
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error while getting daily report ", e);
        }
    }
}

