/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.service;

import cs636.pizza.dao.AdminDAO;
import cs636.pizza.dao.DbDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.dao.PizzaOrderDAO;
import cs636.pizza.domain.MenuSize;
import cs636.pizza.domain.MenuTopping;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.domain.PizzaSize;
import cs636.pizza.domain.PizzaTopping;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentService {
    @Autowired
    private PizzaOrderDAO pizzaOrderDAO;
    @Autowired
    private MenuDAO menuDAO;
    @Autowired
    private AdminDAO adminDAO;
    @Autowired
    private DbDAO dbDAO;

    public Set<String> getSizeNames() throws ServiceException {
        Set<MenuSize> sizes = null;
        TreeSet<String> sizeStrings = new TreeSet<String>();
        try {
            this.dbDAO.startTransaction();
            sizes = this.menuDAO.findMenuSizes();
            for (MenuSize s : sizes) {
                sizeStrings.add(s.getSizeName());
            }
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Can't access pizza sizes in db: ", e);
        }
        return sizeStrings;
    }

    public Set<String> getToppingNames() throws ServiceException {
        Set<MenuTopping> toppings = null;
        TreeSet<String> toppingStrings = new TreeSet<String>();
        try {
            this.dbDAO.startTransaction();
            toppings = this.menuDAO.findMenuToppings();
            for (MenuTopping t : toppings) {
                toppingStrings.add(t.getToppingName());
            }
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Can't access toppings in db: ", e);
        }
        return toppingStrings;
    }

    public void makeOrder(int roomNum, String size, Set<String> toppings) throws ServiceException {
        try {
            this.dbDAO.startTransaction();
            if (this.menuDAO.findMenuSize(size) == null) {
                throw new ServiceException("Order cannot be placed because specified size " + size + " is unavailable");
            }
            PizzaSize pizzaSize = new PizzaSize(size);
            HashSet<PizzaTopping> orderToppings = new HashSet<PizzaTopping>();
            for (String t : toppings) {
                System.out.println("cking topping " + t);
                if (this.menuDAO.findMenuTopping(t) == null) {
                    throw new ServiceException("Order cannot be placed because specified topping " + t + " is unavailable");
                }
                orderToppings.add(new PizzaTopping(t));
            }
            PizzaOrder order = new PizzaOrder(roomNum, pizzaSize, orderToppings, this.adminDAO.findCurrentDay(), 1);
            this.pizzaOrderDAO.insertOrder(order);
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Order can not be placed ", e);
        }
    }

    public List<PizzaOrderData> getOrderStatus(int roomNumber) throws ServiceException {
        List<PizzaOrder> pizzaOrders = null;
        ArrayList<PizzaOrderData> pizzaOrders1 = new ArrayList<PizzaOrderData>();
        try {
            this.dbDAO.startTransaction();
            pizzaOrders = this.pizzaOrderDAO.findOrdersByRoom(roomNumber, this.adminDAO.findCurrentDay());
            for (PizzaOrder order : pizzaOrders) {
                pizzaOrders1.add(new PizzaOrderData(order));
            }
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error in getting status ", e);
        }
        return pizzaOrders1;
    }

    public void receiveOrders(int roomNumber) throws ServiceException {
        List<PizzaOrder> pizzaOrders = null;
        try {
            this.dbDAO.startTransaction();
            pizzaOrders = this.pizzaOrderDAO.findOrdersByRoom(roomNumber, this.adminDAO.findCurrentDay());
            for (PizzaOrder order : pizzaOrders) {
                if (order.getStatus() != 2) continue;
                order.receive();
            }
            this.dbDAO.commitTransaction();
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException();
            throw new ServiceException("Error in getting status" + e, e);
        }
    }
}

