/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.domain;

import cs636.pizza.domain.PizzaSize;
import cs636.pizza.domain.PizzaTopping;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="PIZZA_ORDERS")
public class PizzaOrder
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @TableGenerator(name="OrderNumberGen", table="PIZZA_ID_GEN", pkColumnName="GEN_NAME", valueColumnName="GEN_VAL", pkColumnValue="Ordno_Gen")
    @GeneratedValue(generator="OrderNumberGen")
    @Column(unique=true, nullable=false)
    private int id;
    private int day;
    @Column(name="room_number")
    private int roomNumber;
    private int status;
    public static final int PREPARING = 1;
    public static final int BAKED = 2;
    public static final int FINISHED = 3;
    public static final int NO_SUCH_ORDER = 0;
    private static final String[] STATUS_NAME = new String[]{"NO_SUCH_ORDER", "PREPARING", "BAKED", "FINISHED"};
    @OneToMany(mappedBy="order", cascade={CascadeType.ALL})
    private Set<PizzaTopping> pizzaToppings;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="SIZE_ID")
    private PizzaSize pizzaSize;

    public PizzaOrder() {
    }

    public PizzaOrder(int roomNumber, PizzaSize size, Set<PizzaTopping> pizzaToppings, int day, int status) {
        this.roomNumber = roomNumber;
        this.pizzaSize = size;
        this.day = day;
        this.status = status;
        this.pizzaToppings = pizzaToppings;
        for (PizzaTopping t : pizzaToppings) {
            t.setPizzaOrder(this);
        }
    }

    public void makeReady() {
        this.status = 2;
    }

    public void receive() {
        assert (this.status == 2);
        this.status = 3;
    }

    public void finish() {
        this.status = 3;
    }

    public int getId() {
        return this.id;
    }

    public int getDay() {
        return this.day;
    }

    public int getRoomNumber() {
        return this.roomNumber;
    }

    public int getStatus() {
        return this.status;
    }

    public Set<PizzaTopping> getPizzaToppings() {
        return this.pizzaToppings;
    }

    public void setPizzaToppings(Set<PizzaTopping> pizzaToppings) {
        this.pizzaToppings = pizzaToppings;
    }

    public PizzaTopping addPizzaTopping(PizzaTopping pizzaTopping) {
        this.getPizzaToppings().add(pizzaTopping);
        pizzaTopping.setPizzaOrder(this);
        return pizzaTopping;
    }

    public Set<String> getPizzaToppingNames() {
        TreeSet<String> names = null;
        if (this.pizzaToppings != null) {
            names = new TreeSet<String>();
            for (PizzaTopping t : this.pizzaToppings) {
                names.add(t.getToppingName());
            }
        }
        return names;
    }

    public PizzaSize getPizzaSize() {
        return this.pizzaSize;
    }

    public String statusString() {
        return STATUS_NAME[this.status];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ORDER ID: " + this.getId() + "\n");
        buffer.append("ORDER DAY: " + this.getDay() + "\n");
        buffer.append("SIZE: " + (this.getPizzaSize() != null ? this.getPizzaSize().getSizeName() : "not available") + "\n");
        buffer.append("ROOM NUMBER: " + this.getRoomNumber() + "\n");
        buffer.append("STATUS: " + this.statusString());
        return buffer.toString();
    }
}

