/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation;

import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class PresentationUtils {
    public static final int NUM_OF_ATTEMPTS = 3;
    public static final int NO_MORE = -2;
    public static final String QUIT_KEY = "q";
    public static final int ERROR = -1;

    public static void printOrderStatus(List<PizzaOrderData> report, PrintStream out) {
        for (PizzaOrderData order : report) {
            out.println("----------Order Status--------------");
            out.println("Order " + order.getId());
            out.println(order.getStatusString());
            out.println("Room " + order.getRoomNumber());
            out.print("Order's Toppings: ");
            for (String t : order.getToppings()) {
                out.print(t + " ");
            }
            out.print("\nOrder's Size: ");
            out.println(order.getPizzaSize());
            out.println("-------------------------------------");
        }
    }

    public static void printReport(List<PizzaOrderData> report, PrintStream out) throws ServiceException {
        for (PizzaOrderData order : report) {
            out.println(order);
            out.println("---------------------");
        }
    }

    public static int getMenuEntry(String promptMsg, Map<Integer, String> validEntries, Scanner in) throws IOException {
        for (int loop = 0; loop < 3; ++loop) {
            for (int id : validEntries.keySet()) {
                System.out.println("" + id + "  " + validEntries.get(id));
            }
            String entryLine = PresentationUtils.readEntry(in, promptMsg);
            if (entryLine.equalsIgnoreCase(QUIT_KEY)) {
                return -2;
            }
            int num = -1;
            try {
                num = Integer.parseInt(entryLine);
            }
            catch (NumberFormatException e) {
                System.out.println("Please enter a whole number");
                continue;
            }
            if (validEntries.get(num) != null) {
                return num;
            }
            System.out.println("Not a valid choice, try again");
        }
        System.out.println("Invalid Entry after 3 attempts");
        return -1;
    }

    public static String readEntry(Scanner in, String prompt) throws IOException {
        System.out.println(prompt + ":");
        return in.nextLine().trim();
    }
}

