/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation;

import cs636.pizza.presentation.PresentationUtils;
import cs636.pizza.service.AdminService;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import cs636.pizza.service.StudentService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;

public class SystemTest {
    private AdminService adminService;
    private StudentService studentService;
    private String inFile = null;

    public SystemTest(AdminService as, StudentService ss) {
        this.adminService = as;
        this.studentService = ss;
    }

    public void runSystemTest() throws IOException, ServiceException {
        String command = null;
        if (this.inFile == null) {
            this.inFile = "test.dat";
        }
        Scanner in = new Scanner(new File(this.inFile));
        while ((command = this.getNextCommand(in)) != null) {
            System.out.println("\n\n*************" + command + "***************\n");
            if (command.equalsIgnoreCase("ai")) {
                this.adminService.initializeDb();
                this.adminService.addPizzaSize("small");
                this.adminService.addTopping("Pepperoni");
            } else if (command.equalsIgnoreCase("anr")) {
                this.adminService.markNextOrderReady();
            } else if (command.equalsIgnoreCase("aad")) {
                this.adminService.advanceDay();
            } else if (command.equalsIgnoreCase("aip")) {
                List<PizzaOrderData> report = this.adminService.getTodaysOrdersByStatus(1);
                PresentationUtils.printReport(report, System.out);
                report = this.adminService.getTodaysOrdersByStatus(2);
                PresentationUtils.printReport(report, System.out);
            } else if (command.startsWith("ss")) {
                this.handleOrderStatus(command);
            } else if (command.startsWith("so")) {
                this.handleStudentOrder(command);
            } else if (command.startsWith("sr")) {
                this.handleOrderReceive(command);
            } else {
                System.out.println("Invalid Command: " + command);
            }
            System.out.println("----OK");
        }
        in.close();
    }

    private void handleOrderStatus(String command) throws ServiceException {
        String[] tokens = this.getTokens(command);
        int roomNumber = Integer.parseInt(tokens[1]);
        List<PizzaOrderData> report = this.studentService.getOrderStatus(roomNumber);
        PresentationUtils.printOrderStatus(report, System.out);
    }

    private void handleOrderReceive(String command) throws ServiceException {
        String[] tokens = this.getTokens(command);
        int roomNumber = Integer.parseInt(tokens[1]);
        this.studentService.receiveOrders(roomNumber);
    }

    private void handleStudentOrder(String command) throws ServiceException {
        String[] tokens = this.getTokens(command);
        int roomNumber = Integer.parseInt(tokens[1]);
        Set<String> allToppings = this.studentService.getToppingNames();
        Set<String> allPizzaSizes = this.studentService.getSizeNames();
        String chosenPizzaSize = allPizzaSizes.iterator().next();
        this.studentService.makeOrder(roomNumber, chosenPizzaSize, allToppings);
    }

    public String getNextCommand(Scanner in) throws IOException {
        String line = null;
        try {
            line = in.nextLine();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return line != null ? line.trim() : line;
    }

    private String[] getTokens(String command) {
        return command.split("\\s+");
    }
}

