/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.service;

import cs636.pizza.domain.PizzaOrder;
import java.util.Set;

public class PizzaOrderData {
    private int roomNumber;
    private String pizzaSize;
    private Set<String> toppings;
    private int id;
    private int day;
    private int status;
    private String statusString;
    public static final int PREPARING = 1;
    public static final int BAKED = 2;
    public static final int FINISHED = 3;
    public static final int NO_SUCH_ORDER = 0;

    public PizzaOrderData(int id, int roomNumber, String size, Set<String> toppings, int day, int status, String statusString) {
        this.roomNumber = roomNumber;
        this.pizzaSize = size;
        this.id = id;
        this.day = day;
        this.status = status;
        this.statusString = statusString;
        this.toppings = toppings;
    }

    public PizzaOrderData(PizzaOrder po) {
        this.roomNumber = po.getRoomNumber();
        this.pizzaSize = po.getPizzaSize() == null ? null : po.getPizzaSize().getSizeName();
        this.id = po.getId();
        this.day = po.getDay();
        this.status = po.getStatus();
        this.statusString = po.statusString();
        this.toppings = po.getPizzaToppingNames();
    }

    public Set<String> getToppings() {
        return this.toppings;
    }

    public int getDay() {
        return this.day;
    }

    public int getRoomNumber() {
        return this.roomNumber;
    }

    public String getPizzaSize() {
        return this.pizzaSize;
    }

    public int getId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ORDER ID: " + this.getId() + "\n");
        buffer.append("ORDER DAY: " + this.getDay() + "\n");
        if (this.getPizzaSize() != null) {
            buffer.append("SIZE: " + this.getPizzaSize() + "\n");
        }
        if (this.getToppings() != null) {
            buffer.append("TOPPINGS: ");
            for (String t : this.getToppings()) {
                buffer.append(t);
                buffer.append(" ");
            }
            buffer.append("\n");
        }
        buffer.append("ROOM NUMBER: " + this.getRoomNumber() + "\n");
        buffer.append("STATUS: " + this.getStatusString());
        return buffer.toString();
    }
}

