/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.config;

import cs636.pizza.config.PizzaSystemConfig;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(value={"cs636.pizza"})
@EnableTransactionManagement
public class AppConfig {
    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        Map<String, String> emfProperties = PizzaSystemConfig.getEntityManagerFactoryProperties();
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setPersistenceUnitName("pizza2hib");
        em.setPackagesToScan(new String[]{"cs636.pizza"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        Map<String, String> properties = emfProperties;
        em.setJpaPropertyMap(properties);
        return em;
    }
}

