/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;

public class PizzaSystemConfig {
    public static final int NUM_OF_ROOMS = 10;
    private static Map<String, String> emfProperties;

    public static void configureJPA(String dbUrl, String user, String password) {
        String dbHibernateDialect;
        String dbDriverName;
        System.out.println("NOTE: configureJPA called with dbUrl" + dbUrl);
        if (dbUrl == null) {
            dbUrl = "jdbc:h2:~/test";
            user = "test";
            password = "";
        }
        if (dbUrl.contains("mysql")) {
            dbDriverName = "com.mysql.cj.jdbc.Driver";
            dbHibernateDialect = "org.hibernate.dialect.MySQLDialect";
        } else if (dbUrl.contains("oracle")) {
            dbDriverName = "oracle.jdbc.OracleDriver";
            dbHibernateDialect = "org.hibernate.dialect.Oracle10gDialect";
        } else if (dbUrl.contains("h2")) {
            dbDriverName = "org.h2.Driver";
            dbHibernateDialect = "org.hibernate.dialect.H2Dialect";
        } else {
            throw new RuntimeException("Unknown DB URL " + dbUrl);
        }
        HashMap<String, String> addedOrOverridenProperties = new HashMap<String, String>();
        addedOrOverridenProperties.put("javax.persistence.jdbc.driver", dbDriverName);
        addedOrOverridenProperties.put("hibernate.dialect", dbHibernateDialect);
        addedOrOverridenProperties.put("javax.persistence.jdbc.url", dbUrl);
        addedOrOverridenProperties.put("javax.persistence.jdbc.user", user);
        addedOrOverridenProperties.put("javax.persistence.jdbc.password", password);
        emfProperties = addedOrOverridenProperties;
    }

    public static void testJPA(EntityManagerFactory emf) {
        try {
            System.out.println("starting testJPA");
            EntityManager em = emf.createEntityManager();
            System.out.println("testEMF: Got an EM");
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            tx.commit();
            em.close();
        }
        catch (Exception e) {
            System.out.println(" Exception trying to set up a transaction: " + e + "\n Continuing...");
            e.printStackTrace();
        }
    }

    public static String exceptionReport(Exception e) {
        String message = e.toString();
        if (e.getCause() != null) {
            message = message + "\n  cause: " + e.getCause();
            if (e.getCause().getCause() != null) {
                message = message + "\n    cause's cause: " + e.getCause().getCause();
            }
        }
        message = message + "\n Stack Trace: " + PizzaSystemConfig.exceptionStackTraceString(e);
        return message;
    }

    private static String exceptionStackTraceString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Map<String, String> getEntityManagerFactoryProperties() {
        return emfProperties;
    }
}

