/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.domain;

import cs636.pizza.domain.PizzaOrder;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="PIZZA_TOPPINGS")
public class PizzaTopping
implements Serializable,
Comparable<PizzaTopping> {
    private static final long serialVersionUID = 1L;
    @Id
    @TableGenerator(name="ToppingIdGen", table="PIZZA_ID_GEN", pkColumnName="GEN_NAME", valueColumnName="GEN_VAL", pkColumnValue="ToppingId_Gen")
    @GeneratedValue(generator="ToppingIdGen")
    @Column(unique=true, nullable=false)
    private int id;
    @ManyToOne
    @JoinColumn(name="ORDER_ID")
    private PizzaOrder order;
    @Column(name="TOPPING_NAME")
    private String toppingName;

    public PizzaTopping() {
    }

    public PizzaTopping(String toppingName) {
        this.toppingName = toppingName;
    }

    public void setPizzaOrder(PizzaOrder order) {
        this.order = order;
    }

    public int getId() {
        return this.id;
    }

    public String getToppingName() {
        return this.toppingName;
    }

    @Override
    public int compareTo(PizzaTopping x) {
        return this.getToppingName().compareTo(x.getToppingName());
    }

    public boolean equals(Object x) {
        if (x == null || x.getClass() != this.getClass()) {
            return false;
        }
        return this.getToppingName().equals(((PizzaTopping)x).getToppingName());
    }

    public int hashCode() {
        return this.getToppingName().hashCode();
    }
}

