/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation;

import cs636.pizza.config.PizzaSystemConfig;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;

@SpringBootApplication(scanBasePackages={"cs636.pizza"})
@EntityScan(value={"cs636.pizza"})
public class ClientApplication {
    public static void main(String[] args) {
        System.out.println("starting ClientApplication...");
        String dbUrl = null;
        String usr = null;
        String pw = null;
        if (args.length > 1) {
            if (args.length == 4) {
                dbUrl = args[1];
                usr = args[2];
                pw = args[3];
            } else {
                System.out.println("usage:java [<inputFile>] <dbURL> <user> <passwd> ");
                return;
            }
        }
        System.out.println("running ClientApplication with db args: " + dbUrl + " " + usr + " " + pw);
        PizzaSystemConfig.configureJPA(dbUrl, usr, pw);
        SpringApplication app = new SpringApplication(new Class[]{ClientApplication.class});
        app.setBannerMode(Banner.Mode.OFF);
        app.setWebApplicationType(WebApplicationType.NONE);
        System.out.println("starting ClientRun...");
        app.run(args);
        System.out.println("... ending ClientRun");
    }
}

