/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.service;

import cs636.pizza.dao.AdminDAO;
import cs636.pizza.dao.DbDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.dao.PizzaOrderDAO;
import cs636.pizza.dao.PizzaOrderRepository;
import cs636.pizza.dao.ToppingRepository;
import cs636.pizza.domain.MenuTopping;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminService {
    @Autowired
    private ToppingRepository topRep;
    @Autowired
    private PizzaOrderRepository pizzaOrderRep;
    @Autowired
    private DbDAO dbDAO;
    @Autowired
    private AdminDAO adminDAO;
    @Autowired
    private MenuDAO menuDAO;
    @Autowired
    private PizzaOrderDAO pizzaOrderDAO;

    @Transactional
    public void initializeDb() throws ServiceException {
        this.dbDAO.initializeDb();
    }

    @Transactional
    public void addTopping(String name) throws ServiceException {
        this.menuDAO.createMenuTopping(name);
    }

    @Transactional
    public void addTopping1(MenuTopping top) {
        System.out.println("addTopping1, see top of " + top.getToppingName());
        this.topRep.save(top);
    }

    @Transactional
    public void removeTopping1(MenuTopping top) {
        System.out.println("removeTopping1, see top of " + top.getToppingName());
        this.topRep.delete(top);
    }

    @Transactional
    public MenuTopping findByName(String name) {
        System.out.println("findByToppingName, name = " + name);
        return this.topRep.findByToppingName(name);
    }

    @Transactional
    public void removeTopping(String topping) {
        this.menuDAO.deleteMenuTopping(topping);
    }

    @Transactional
    public void addPizzaSize(String name) throws ServiceException {
        this.menuDAO.createMenuSize(name);
    }

    @Transactional
    public void removePizzaSize(String size) throws ServiceException {
        this.menuDAO.deleteMenuSize(size);
    }

    @Transactional
    public void markNextOrderReady() throws ServiceException {
        PizzaOrder order = null;
        order = this.pizzaOrderDAO.findFirstOrder(1);
        if (order == null) {
            throw new ServiceException("No PREPARING orders exist!");
        }
        order.makeReady();
    }

    @Transactional
    public void markNextOrderReady1() throws ServiceException {
        PizzaOrder order = null;
        order = this.pizzaOrderRep.findByStatusOrderById(1).iterator().next();
        if (order == null) {
            throw new ServiceException("No PREPARING orders exist!");
        }
        order.makeReady();
    }

    @Transactional
    public int getCurrentDay() {
        int day = this.adminDAO.findCurrentDay();
        return day;
    }

    @Transactional
    public void advanceDay() {
        List<PizzaOrder> pizzaOrders = this.getTodaysOrders();
        for (PizzaOrder order : pizzaOrders) {
            order.finish();
        }
        this.adminDAO.advanceDay();
    }

    private List<PizzaOrder> getTodaysOrders() {
        int today = this.adminDAO.findCurrentDay();
        List<PizzaOrder> orders = this.pizzaOrderDAO.findOrdersByDays(today, today);
        return orders;
    }

    @Transactional
    public List<PizzaOrderData> getOrdersByDay(int day) {
        List<PizzaOrder> orders = this.pizzaOrderDAO.findOrdersByDays(day, day);
        ArrayList<PizzaOrderData> orders1 = new ArrayList<PizzaOrderData>();
        for (PizzaOrder o : orders) {
            orders1.add(new PizzaOrderData(o));
        }
        return orders1;
    }

    @Transactional
    public List<PizzaOrderData> getTodaysOrdersByStatus(int status) {
        List<PizzaOrder> orders = this.getTodaysOrders();
        ArrayList<PizzaOrderData> orders1 = new ArrayList<PizzaOrderData>();
        for (PizzaOrder o : orders) {
            if (o.getStatus() != status) continue;
            orders1.add(new PizzaOrderData(o));
        }
        return orders1;
    }
}

