/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.dao;

import cs636.pizza.dao.DbDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.domain.PizzaTopping;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PizzaOrderDAO {
    @Autowired
    private DbDAO dbDAO;
    @Autowired
    private MenuDAO menuDAO;

    public PizzaOrderDAO(DbDAO db, MenuDAO menuDAO) {
        this.dbDAO = db;
        this.menuDAO = menuDAO;
    }

    public void insertOrder(PizzaOrder order) {
        EntityManager em = this.dbDAO.getEM();
        String sizeName = order.getPizzaSize().getSizeName();
        if (this.menuDAO.findMenuSize(sizeName) == null) {
            throw new IllegalArgumentException("no such pizza size available");
        }
        for (PizzaTopping t : order.getPizzaToppings()) {
            if (this.menuDAO.findMenuTopping(t.getToppingName()) != null) continue;
            throw new IllegalArgumentException("no such pizza topping available");
        }
        em.persist((Object)order);
    }

    public List<PizzaOrder> findOrdersByRoom(int roomNumber, int day) {
        TypedQuery query = this.dbDAO.getEM().createQuery("select o from PizzaOrder o where o.roomNumber = " + roomNumber + " and o.day = " + day + " order by o.id", PizzaOrder.class);
        List orders = query.getResultList();
        return orders;
    }

    public PizzaOrder findFirstOrder(int status) {
        TypedQuery query = this.dbDAO.getEM().createQuery("select o from PizzaOrder o where o.status = " + status + " order by o.id", PizzaOrder.class);
        List orders = query.getResultList();
        if (orders.isEmpty()) {
            return null;
        }
        return (PizzaOrder)orders.get(0);
    }

    public List<PizzaOrder> findOrdersByDays(int day1, int day2) {
        TypedQuery query = this.dbDAO.getEM().createQuery("select o from PizzaOrder o where o.day >= " + day1 + " and o.day <= " + day2 + " order by o.id", PizzaOrder.class);
        List orders = query.getResultList();
        return orders;
    }
}

