/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.service;

import cs636.pizza.dao.AdminDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.dao.PizzaOrderDAO;
import cs636.pizza.dao.PizzaOrderRepository;
import cs636.pizza.domain.MenuSize;
import cs636.pizza.domain.MenuTopping;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.domain.PizzaSize;
import cs636.pizza.domain.PizzaTopping;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentService {
    @Autowired
    private PizzaOrderDAO pizzaOrderDAO;
    @Autowired
    private MenuDAO menuDAO;
    @Autowired
    private AdminDAO adminDAO;
    @Autowired
    private PizzaOrderRepository pizzaOrderRep;

    @Transactional
    public Set<String> getSizeNames() throws ServiceException {
        Set<MenuSize> sizes = null;
        TreeSet<String> sizeStrings = new TreeSet<String>();
        sizes = this.menuDAO.findMenuSizes();
        for (MenuSize s : sizes) {
            sizeStrings.add(s.getSizeName());
        }
        return sizeStrings;
    }

    @Transactional
    public Set<String> getToppingNames() throws ServiceException {
        Set<MenuTopping> toppings = null;
        TreeSet<String> toppingStrings = new TreeSet<String>();
        toppings = this.menuDAO.findMenuToppings();
        for (MenuTopping t : toppings) {
            toppingStrings.add(t.getToppingName());
        }
        return toppingStrings;
    }

    @Transactional
    public void makeOrder(int roomNum, String size, Set<String> toppings) throws ServiceException {
        if (this.menuDAO.findMenuSize(size) == null) {
            throw new ServiceException("Order cannot be placed because specified size " + size + " is unavailable");
        }
        PizzaSize pizzaSize = new PizzaSize(size);
        HashSet<PizzaTopping> orderToppings = new HashSet<PizzaTopping>();
        for (String t : toppings) {
            System.out.println("cking topping " + t);
            if (this.menuDAO.findMenuTopping(t) == null) {
                throw new ServiceException("Order cannot be placed because specified topping " + t + " is unavailable");
            }
            orderToppings.add(new PizzaTopping(t));
        }
        PizzaOrder order = new PizzaOrder(roomNum, pizzaSize, orderToppings, this.adminDAO.findCurrentDay(), 1);
        this.pizzaOrderDAO.insertOrder(order);
    }

    @Transactional
    public List<PizzaOrderData> getOrderStatus(int roomNumber) throws ServiceException {
        List<PizzaOrder> pizzaOrders = null;
        ArrayList<PizzaOrderData> pizzaOrders1 = new ArrayList<PizzaOrderData>();
        pizzaOrders = this.pizzaOrderDAO.findOrdersByRoom(roomNumber, this.adminDAO.findCurrentDay());
        for (PizzaOrder order : pizzaOrders) {
            pizzaOrders1.add(new PizzaOrderData(order));
        }
        return pizzaOrders1;
    }

    @Transactional
    public List<PizzaOrderData> getOrderStatus1(int roomNumber) throws ServiceException {
        List<PizzaOrder> pizzaOrders = null;
        ArrayList<PizzaOrderData> pizzaOrders1 = new ArrayList<PizzaOrderData>();
        pizzaOrders = this.pizzaOrderRep.findByRoomNumberAndDay(roomNumber, this.adminDAO.findCurrentDay());
        for (PizzaOrder order : pizzaOrders) {
            pizzaOrders1.add(new PizzaOrderData(order));
        }
        return pizzaOrders1;
    }

    @Transactional
    public void receiveOrders(int roomNumber) throws ServiceException {
        List<PizzaOrder> pizzaOrders = null;
        pizzaOrders = this.pizzaOrderDAO.findOrdersByRoom(roomNumber, this.adminDAO.findCurrentDay());
        for (PizzaOrder order : pizzaOrders) {
            if (order.getStatus() != 2) continue;
            order.receive();
        }
    }
}

