/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.domain;

import cs636.pizza.domain.PizzaSize;
import cs636.pizza.domain.PizzaTopping;
import java.util.Set;
import java.util.TreeSet;

public class PizzaOrder {
    private int roomNumber;
    private PizzaSize pizzaSize;
    private Set<PizzaTopping> pizzaToppings;
    private int id;
    private int day;
    private int status;
    public static final int PREPARING = 1;
    public static final int BAKED = 2;
    public static final int FINISHED = 3;
    public static final int NO_SUCH_ORDER = 0;
    private static final String[] STATUS_NAME = new String[]{"NO_SUCH_ORDER", "PREPARING", "BAKED", "FINISHED"};

    public PizzaOrder(int roomNumber, PizzaSize size, Set<PizzaTopping> PizzaToppings, int day, int status) {
        this(-1, roomNumber, size, PizzaToppings, day, status);
    }

    public PizzaOrder(int id, int roomNumber, PizzaSize size, Set<PizzaTopping> pizzaToppings, int day, int status) {
        this.roomNumber = roomNumber;
        this.pizzaSize = size;
        this.id = id;
        this.day = day;
        this.status = status;
        this.pizzaToppings = pizzaToppings;
    }

    public void makeReady() {
        this.status = 2;
    }

    public void receive() {
        assert (this.status == 2);
        this.status = 3;
    }

    public void finish() {
        this.status = 3;
    }

    public void addPizzaTopping(PizzaTopping PizzaTopping2) {
        this.pizzaToppings.add(PizzaTopping2);
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<PizzaTopping> getPizzaToppings() {
        return this.pizzaToppings;
    }

    public Set<String> getPizzaToppingNames() {
        TreeSet<String> names = null;
        if (this.pizzaToppings != null) {
            names = new TreeSet<String>();
            for (PizzaTopping t : this.pizzaToppings) {
                names.add(t.getToppingName());
            }
        }
        return names;
    }

    public boolean containsPizzaTopping(PizzaTopping PizzaTopping2) {
        return this.pizzaToppings.contains(PizzaTopping2);
    }

    public int getDay() {
        return this.day;
    }

    public int getRoomNumber() {
        return this.roomNumber;
    }

    public PizzaSize getPizzaSize() {
        return this.pizzaSize;
    }

    public int getId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public String statusString() {
        return STATUS_NAME[this.status];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ORDER ID: " + this.getId() + "\n");
        buffer.append("ORDER DAY: " + this.getDay() + "\n");
        if (this.getPizzaSize() != null) {
            buffer.append("SIZE: " + this.getPizzaSize().getSizeName() + "\n");
        }
        if (this.getPizzaToppings() != null) {
            buffer.append("PizzaToppingS: ");
            for (PizzaTopping t : this.getPizzaToppings()) {
                buffer.append(t.getToppingName());
                buffer.append(" ");
            }
            buffer.append("\n");
        }
        buffer.append("ROOM NUMBER: " + this.getRoomNumber() + "\n");
        buffer.append("STATUS: " + this.statusString());
        return buffer.toString();
    }
}

