/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.service;

import cs636.pizza.dao.AdminDAO;
import cs636.pizza.dao.DbDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.dao.PizzaOrderDAO;
import cs636.pizza.domain.MenuSize;
import cs636.pizza.domain.MenuTopping;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.domain.PizzaSize;
import cs636.pizza.domain.PizzaTopping;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentService {
    @Autowired
    private PizzaOrderDAO pizzaOrderDAO;
    @Autowired
    private MenuDAO menuDAO;
    @Autowired
    private AdminDAO adminDAO;
    @Autowired
    private DbDAO dbDAO;

    public List<String> getSizeNames() throws ServiceException {
        Connection connection = null;
        Set<MenuSize> sizes = null;
        ArrayList<String> sizeStrings = new ArrayList<String>();
        try {
            connection = this.dbDAO.startTransaction();
            sizes = this.menuDAO.findMenuSizes(connection);
            for (MenuSize s : sizes) {
                sizeStrings.add(s.getSizeName());
            }
            this.dbDAO.commitTransaction(connection);
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException(connection);
            throw new ServiceException("Can't access pizza sizes in db: ", e);
        }
        return sizeStrings;
    }

    public List<String> getToppingNames() throws ServiceException {
        Connection connection = null;
        Set<MenuTopping> toppings = null;
        ArrayList<String> toppingStrings = new ArrayList<String>();
        try {
            connection = this.dbDAO.startTransaction();
            toppings = this.menuDAO.findMenuToppings(connection);
            for (MenuTopping t : toppings) {
                toppingStrings.add(t.getToppingName());
            }
            this.dbDAO.commitTransaction(connection);
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException(connection);
            throw new ServiceException("Can't access toppings in db: ", e);
        }
        return toppingStrings;
    }

    public void makeOrder(int roomNum, String size, List<String> allToppings) throws ServiceException {
        Connection connection = null;
        try {
            connection = this.dbDAO.startTransaction();
            if (this.menuDAO.findMenuSize(connection, size) == null) {
                throw new ServiceException("Order cannot be placed because specified size " + size + " is unavailable");
            }
            PizzaSize pizzaSize = new PizzaSize(size);
            HashSet<PizzaTopping> orderToppings = new HashSet<PizzaTopping>();
            for (String t : allToppings) {
                if (this.menuDAO.findMenuTopping(connection, t) == null) {
                    throw new ServiceException("Order cannot be placed because specified topping " + t + " is unavailable");
                }
                orderToppings.add(new PizzaTopping(t));
            }
            PizzaOrder order = new PizzaOrder(roomNum, pizzaSize, orderToppings, this.adminDAO.findCurrentDay(connection), 1);
            this.pizzaOrderDAO.insertOrder(connection, order);
            this.dbDAO.commitTransaction(connection);
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException(connection);
            throw new ServiceException("Order can not be placed ", e);
        }
    }

    public List<PizzaOrderData> getOrderStatus(int roomNumber) throws ServiceException {
        Connection connection = null;
        List<PizzaOrder> pizzaOrders = null;
        ArrayList<PizzaOrderData> pizzaOrders1 = new ArrayList<PizzaOrderData>();
        try {
            connection = this.dbDAO.startTransaction();
            pizzaOrders = this.pizzaOrderDAO.findOrdersByRoom(connection, roomNumber, this.adminDAO.findCurrentDay(connection));
            for (PizzaOrder order : pizzaOrders) {
                if (order.getStatus() != 2 && order.getStatus() != 1) continue;
                pizzaOrders1.add(new PizzaOrderData(order));
            }
            this.dbDAO.commitTransaction(connection);
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException(connection);
            throw new ServiceException("Error in getting status ", e);
        }
        return pizzaOrders1;
    }

    public void receiveOrders(int roomNumber) throws ServiceException {
        Connection connection = null;
        List<PizzaOrder> pizzaOrders = null;
        try {
            connection = this.dbDAO.startTransaction();
            pizzaOrders = this.pizzaOrderDAO.findOrdersByRoom(connection, roomNumber, this.adminDAO.findCurrentDay(connection));
            for (PizzaOrder order : pizzaOrders) {
                if (order.getStatus() != 2) continue;
                order.receive();
                this.pizzaOrderDAO.updateOrderStatus(connection, order.getId(), 3);
            }
            this.dbDAO.commitTransaction(connection);
        }
        catch (Exception e) {
            this.dbDAO.rollbackAfterException(connection);
            throw new ServiceException("Error in getting status" + e, e);
        }
    }
}

