/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation.clientserver;

import cs636.pizza.config.PizzaSystemConfig;
import cs636.pizza.presentation.clientserver.PresentationUtils;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import cs636.pizza.service.StudentService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeMap;

public class TakeOrder {
    private StudentService studentService;
    private Scanner in = new Scanner(System.in);

    public TakeOrder(StudentService studentService) throws Exception {
        this.studentService = studentService;
    }

    public void runTakeOrder() {
        try {
            System.out.println("starting TakeOrder app");
            while (this.executeCommand()) {
            }
            System.out.println("Thanks for visiting the pizza shop.");
        }
        catch (Exception e) {
            System.out.println("Error in run of ShopAdmin: ");
            System.out.println(PizzaSystemConfig.exceptionReport(e));
        }
    }

    public boolean executeCommand() throws IOException {
        System.out.println("Possible Commands");
        System.out.println("O: Order");
        System.out.println("S: Status Report");
        System.out.println("R: Receive Order (acknowledge receipt)");
        System.out.println("Q: Quit");
        String command = PresentationUtils.readEntry(this.in, "Please Enter the Command");
        if (command.equalsIgnoreCase("O")) {
            try {
                this.getTheOrder();
            }
            catch (ServiceException e) {
                System.out.println("Sorry, problem with inserting order: ");
                System.out.println(PizzaSystemConfig.exceptionReport(e));
            }
        }
        if (command.equalsIgnoreCase("R")) {
            String room = PresentationUtils.readEntry(this.in, "Enter the room number");
            try {
                this.studentService.receiveOrders(Integer.parseInt(room));
            }
            catch (ServiceException e) {
                System.out.println("Sorry, problem with recording receipt of order: ");
                System.out.println(PizzaSystemConfig.exceptionReport(e));
            }
        } else if (command.equalsIgnoreCase("S")) {
            String room = PresentationUtils.readEntry(this.in, "Enter the room number");
            try {
                List<PizzaOrderData> report = this.studentService.getOrderStatus(Integer.parseInt(room));
                PresentationUtils.printOrderStatus(report, System.out);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid Input!");
            }
            catch (ServiceException e) {
                System.out.println("Sorry, problem with getting order status: ");
                System.out.println(PizzaSystemConfig.exceptionReport(e));
            }
        } else {
            if (command.equalsIgnoreCase("Q")) {
                return false;
            }
            System.out.println("Invalid Command!");
        }
        return true;
    }

    public void getTheOrder() throws IOException, ServiceException {
        int currToppingNum;
        String roomNumStr = PresentationUtils.readEntry(this.in, "Please Enter the room Number");
        int roomNum = 0;
        roomNum = this.checkNumInput(roomNumStr, 10);
        if (roomNum < 0) {
            System.out.println("Invalid Room Number");
            return;
        }
        this.listMenu();
        System.out.println("Available pizza sizes to choose from:");
        List<String> allSizes = this.studentService.getSizeNames();
        if (allSizes.size() == 0) {
            System.out.println("Sorry, no pizza sizes available (admin needs to add them)");
            return;
        }
        TreeMap<Integer, String> sizeTokens = new TreeMap<Integer, String>();
        int choiceNum = 1;
        for (String s : allSizes) {
            sizeTokens.put(choiceNum++, s);
        }
        int sizeChoice = PresentationUtils.getMenuEntry("Enter the size #", sizeTokens, this.in);
        if (sizeChoice < 0) {
            System.out.println("No size specified, please try again");
            return;
        }
        String chosenSize = (String)sizeTokens.get(sizeChoice);
        System.out.println("Available pizza toppings to choose from:");
        List<String> allToppings = this.studentService.getToppingNames();
        TreeMap<Integer, String> toppingTokens = new TreeMap<Integer, String>();
        int toppingChoice = 1;
        for (String t : allToppings) {
            toppingTokens.put(toppingChoice++, t);
        }
        ArrayList<String> chosenToppings = new ArrayList<String>();
        while ((currToppingNum = PresentationUtils.getMenuEntry("Enter Topping number, or q for no more Toppings", toppingTokens, this.in)) != -2) {
            String currToppingName = (String)toppingTokens.get(currToppingNum);
            chosenToppings.add(currToppingName);
        }
        this.studentService.makeOrder(roomNum, chosenSize, chosenToppings);
        System.out.println("Thank you for your order");
    }

    private int checkNumInput(String numStr, int maxBound) {
        int num = 0;
        try {
            num = Integer.parseInt(numStr);
            if (num > 0 && num <= maxBound) {
                return num;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private void listMenu() throws ServiceException {
        System.out.println("Basic Pizza: tomato sauce and cheese ");
        System.out.println("Additional toppings:");
        List<String> toppings = this.studentService.getToppingNames();
        for (String t : toppings) {
            System.out.println("  " + t);
        }
        System.out.println("Sizes:");
        List<String> sizes = this.studentService.getSizeNames();
        for (String s : sizes) {
            System.out.println("  " + s);
        }
    }
}

