/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DbDAO {
    @Autowired
    private DataSource dataSource;

    public void initializeDb() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        this.clearTable(connection, "pizza_toppings");
        this.clearTable(connection, "pizza_orders");
        this.clearTable(connection, "pizza_sizes");
        this.clearTable(connection, "menu_toppings");
        this.clearTable(connection, "menu_sizes");
        this.clearTable(connection, "pizza_sys_tab");
        this.initSysTable(connection);
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTable(Connection connection, String tableName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("delete from " + tableName);
        }
    }

    private void initSysTable(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("insert into pizza_sys_tab values (1,1,1,1,1,1)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advanceId(Connection connection, String columnName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(" update pizza_sys_tab set " + columnName + " = " + columnName + " + 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findNextId(Connection connection, String columnName) throws SQLException {
        int nextId;
        try (Statement stmt = connection.createStatement();){
            ResultSet set = stmt.executeQuery(" select " + columnName + " from " + "pizza_sys_tab");
            set.next();
            nextId = set.getInt(columnName);
        }
        this.advanceId(connection, columnName);
        return nextId;
    }

    public Connection startTransaction() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    public void commitTransaction(Connection connection) throws SQLException {
        connection.commit();
        connection.close();
    }

    public void rollbackTransaction(Connection connection) throws SQLException {
        connection.rollback();
        connection.close();
    }

    public void rollbackAfterException(Connection connection) {
        try {
            this.rollbackTransaction(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

