/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.dao;

import cs636.pizza.dao.DbDAO;
import cs636.pizza.dao.MenuDAO;
import cs636.pizza.domain.PizzaOrder;
import cs636.pizza.domain.PizzaSize;
import cs636.pizza.domain.PizzaTopping;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PizzaOrderDAO {
    @Autowired
    DbDAO dbDAO;
    @Autowired
    private MenuDAO menuDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrder(Connection connection, PizzaOrder order) throws SQLException {
        String sizeName = order.getPizzaSize().getSizeName();
        if (this.menuDAO.findMenuSize(connection, sizeName) == null) {
            throw new SQLException("no such pizza size available");
        }
        for (PizzaTopping t : order.getPizzaToppings()) {
            if (this.menuDAO.findMenuTopping(connection, t.getToppingName()) != null) continue;
            throw new SQLException("no such pizza topping available");
        }
        int ordNo = this.dbDAO.findNextId(connection, "next_order_id");
        int sid = this.dbDAO.findNextId(connection, "next_pizza_size_id");
        order.setId(ordNo);
        try (Statement stmt = connection.createStatement();){
            String sqlString = "insert into pizza_sizes values (" + sid + " , '" + order.getPizzaSize().getSizeName() + "')";
            stmt.execute(sqlString);
            sqlString = "insert into pizza_orders values (" + ordNo + ", " + order.getRoomNumber() + ", " + sid + ", " + order.getDay() + ", " + order.getStatus() + ") ";
            stmt.execute(sqlString);
            Set<PizzaTopping> toppings = order.getPizzaToppings();
            for (PizzaTopping t : toppings) {
                int tid = this.dbDAO.findNextId(connection, "next_pizza_topping_id");
                sqlString = "insert into pizza_toppings values (" + order.getId() + ", " + tid + " , '" + t.getToppingName() + "') ";
                stmt.execute(sqlString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PizzaOrder> findOrdersByRoom(Connection connection, int roomNumber, int day) throws SQLException {
        String sqlString = "SELECT o.*, s.*, ot.* FROM pizza_orders o LEFT OUTER JOIN pizza_toppings ot  ON o.id = ot.order_id JOIN pizza_sizes s ON o.size_id = s.id WHERE o.room_number = " + roomNumber + " and o.day = " + day + " ORDER BY o.id";
        TreeMap<Integer, PizzaOrder> statusMap = new TreeMap<Integer, PizzaOrder>();
        try (Statement stmt = connection.createStatement();){
            ResultSet table = stmt.executeQuery(sqlString);
            while (table.next()) {
                int ordNo = table.getInt("order_id");
                PizzaOrder order = null;
                String toppingName = table.getString("topping_name");
                PizzaTopping topping = new PizzaTopping(ordNo, ordNo, toppingName);
                order = (PizzaOrder)statusMap.get(ordNo);
                if (order != null) {
                    order.addPizzaTopping(topping);
                    continue;
                }
                TreeSet<PizzaTopping> toppings = new TreeSet<PizzaTopping>();
                toppings.add(topping);
                PizzaSize size = new PizzaSize(table.getString("size_name"));
                int status = table.getInt("status");
                order = new PizzaOrder(ordNo, roomNumber, size, toppings, day, status);
                statusMap.put(ordNo, order);
            }
        }
        return new LinkedList<PizzaOrder>(statusMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PizzaOrder findFirstOrder(Connection connection, int status) throws SQLException {
        PizzaOrder po = null;
        try (Statement stmt = connection.createStatement();){
            ResultSet set = null;
            set = stmt.executeQuery("select * from pizza_orders where status = " + status + " order by id");
            if (set.next()) {
                po = new PizzaOrder(set.getInt("id"), set.getInt("room_number"), null, null, set.getInt("day"), set.getInt("status"));
            }
        }
        return po;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrderStatus(Connection connection, int ordNo, int newStatus) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(" update pizza_orders set status = " + newStatus + " where id = " + ordNo);
        }
    }

    public List<PizzaOrder> findOrdersByDays(Connection connection, int day1, int day2) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet report = stmt.executeQuery("select id, room_number, day, status from pizza_orders where day >= " + day1 + " and day <= " + day2 + " order by id");
        LinkedList<PizzaOrder> reportSet = new LinkedList<PizzaOrder>();
        while (report.next()) {
            reportSet.add(new PizzaOrder(report.getInt("id"), report.getInt("room_number"), null, null, report.getInt("day"), report.getInt("status")));
        }
        stmt.close();
        return reportSet;
    }
}

