/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation.web;

import cs636.pizza.config.PizzaSystemConfig;
import cs636.pizza.presentation.SystemTest;
import cs636.pizza.service.AdminService;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import cs636.pizza.service.StudentService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdminController {
    @Autowired
    private AdminService adminService;
    @Autowired
    private StudentService studentService;
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    private static final String ADMIN_BASE_URL = "/adminController/";
    private static final String ADMIN_JSP_DIR = "admin/";

    @RequestMapping(value={"/adminController/initializeDB.html"})
    public String adminInitDB(Model model) {
        String info;
        try {
            this.adminService.initializeDb();
            info = "Initialize db: success";
        }
        catch (ServiceException e) {
            info = "Initialize db: failed " + PizzaSystemConfig.exceptionReport(e);
        }
        model.addAttribute("info", (Object)info);
        String url = "admin/initializeDB";
        return url;
    }

    @RequestMapping(value={"/adminController/sysTest.html"})
    public String sysTest(Model model) {
        String info;
        try {
            SystemTest test = new SystemTest(this.adminService, this.studentService);
            test.runSystemTest();
            info = "SystemTest success: see console log for output";
        }
        catch (Exception e) {
            info = "SystemTest failed: " + PizzaSystemConfig.exceptionReport(e);
        }
        model.addAttribute("info", (Object)info);
        String url = "admin/initializeDB";
        return url;
    }

    @RequestMapping(value={"/adminController/adminWelcome.html"})
    public String adminWelcome(Model model) {
        String url = "admin/adminWelcome";
        return url;
    }

    @RequestMapping(value={"/adminController/listVariables.html"})
    public String listVariables(Model model) {
        model.addAttribute("dbUrl", (Object)this.dbUrl);
        System.out.println("dbUrl from application.properties: " + this.dbUrl);
        String url = "admin/listVariables";
        return url;
    }

    @RequestMapping(value={"/adminController/logout.html"})
    public String logout(Model model, HttpServletRequest request) {
        request.getSession().invalidate();
        String url = "admin/logout";
        return url;
    }

    @RequestMapping(value={"/adminController/days"})
    public String manageDays(Model model, @RequestParam(value="command", required=false) String command) {
        if (command != null && command.equals("advance")) {
            try {
                this.adminService.advanceDay();
            }
            catch (ServiceException e) {
                String error = "manageDays failed: " + PizzaSystemConfig.exceptionReport(e);
                model.addAttribute("error", (Object)error);
                String url = "admin/error";
                return url;
            }
        }
        int day = 0;
        List<PizzaOrderData> orders1 = null;
        try {
            day = this.adminService.getCurrentDay();
            orders1 = this.adminService.getOrdersByDay(day);
            System.out.println("seeing " + orders1.size() + " orders");
        }
        catch (ServiceException e) {
            String error = "manageDays failed: " + PizzaSystemConfig.exceptionReport(e);
            model.addAttribute("error", (Object)error);
            String url = "admin/error";
            return url;
        }
        model.addAttribute("currentDay", (Object)day);
        model.addAttribute("orders", orders1);
        String url = "admin/dayView";
        return url;
    }

    @RequestMapping(value={"/adminController/orders"})
    public String manageOrders(Model model, @RequestParam(value="command", required=false) String command) {
        System.out.println("in manageOrders, seeing command = " + command);
        if (command != null && command.equals("mark")) {
            try {
                this.adminService.markNextOrderReady();
            }
            catch (ServiceException e) {
                String error = "manageOrders failed: " + PizzaSystemConfig.exceptionReport(e);
                model.addAttribute("error", (Object)error);
                String url = "admin/error";
                return url;
            }
        }
        List<PizzaOrderData> orders1 = null;
        List<PizzaOrderData> orders2 = null;
        try {
            orders1 = this.adminService.getTodaysOrdersByStatus(1);
            System.out.println("seeing " + orders1.size() + " preparing orders");
            orders2 = this.adminService.getTodaysOrdersByStatus(2);
            System.out.println("seeing " + orders2.size() + " baked orders");
        }
        catch (ServiceException e) {
            String error = "manageOrders failed: " + PizzaSystemConfig.exceptionReport(e);
            model.addAttribute("error", (Object)error);
            String url = "admin/error";
            return url;
        }
        model.addAttribute("orders_preparing", orders1);
        model.addAttribute("orders_baked", orders2);
        String url = "admin/orderView";
        return url;
    }

    @RequestMapping(value={"/adminController/toppings"})
    public String manageToppings(Model model, @RequestParam(value="command", required=false) String command, @RequestParam(value="item", required=false) String item) {
        List<String> allToppings = null;
        try {
            if (item != null) {
                if (command == null || command.equalsIgnoreCase("add")) {
                    this.adminService.addTopping(item);
                } else if (command.equalsIgnoreCase("remove")) {
                    this.removeTopping(item);
                } else {
                    String error = "manageToppings failed because of bad request parameter: " + command;
                    System.out.println(error);
                    model.addAttribute("error", (Object)error);
                    String url = "admin/error";
                    return url;
                }
            }
            allToppings = this.studentService.getToppingNames();
        }
        catch (ServiceException e) {
            String error = PizzaSystemConfig.exceptionReport(e);
            model.addAttribute("error", (Object)error);
            String url = "admin/error";
            return url;
        }
        model.addAttribute("allToppings", allToppings);
        String url = "admin/toppingView";
        return url;
    }

    @RequestMapping(value={"/adminController/sizes"})
    public String manageSizes(Model model, @RequestParam(value="command", required=false) String command, @RequestParam(value="item", required=false) String item) {
        List<String> allSizes = null;
        try {
            if (item != null) {
                if (command == null || command.equalsIgnoreCase("add")) {
                    this.adminService.addPizzaSize(item);
                } else if (command.equalsIgnoreCase("remove")) {
                    this.removeSize(item);
                } else {
                    String error = "manageSizess failed because of bad request parameter: " + command;
                    model.addAttribute("error", (Object)error);
                    String url = "admin/error";
                    return url;
                }
            }
            allSizes = this.studentService.getSizeNames();
        }
        catch (ServiceException e) {
            String error = PizzaSystemConfig.exceptionReport(e);
            model.addAttribute("error", (Object)error);
            String url = "admin/error";
            return url;
        }
        model.addAttribute("allSizes", allSizes);
        String url = "admin/sizeView";
        return url;
    }

    private void removeSize(String size) throws ServiceException {
        this.adminService.removePizzaSize(size);
    }

    private void removeTopping(String topping) throws ServiceException {
        this.adminService.removeTopping(topping);
    }
}

