/*
 * Decompiled with CFR 0.152.
 */
package cs636.pizza.presentation.web;

import cs636.pizza.config.PizzaSystemConfig;
import cs636.pizza.presentation.web.StudentBean;
import cs636.pizza.service.PizzaOrderData;
import cs636.pizza.service.ServiceException;
import cs636.pizza.service.StudentService;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class StudentController {
    @Autowired
    private StudentService studentService;

    @RequestMapping(value={"welcome.html"})
    public String welcome(Model model) {
        return "welcome";
    }

    @RequestMapping(value={"studentWelcome.html"})
    public String displayWelcome(Model model, @RequestParam(value="room", required=false) String chosenRoom, HttpServletRequest request) throws ServletException {
        StudentBean student;
        Integer roomNo = null;
        if (chosenRoom != null) {
            try {
                roomNo = Integer.parseInt(chosenRoom);
                System.out.println("Got roomNo from param = " + roomNo);
            }
            catch (NumberFormatException e) {
                System.out.println("studentWelcome: bad number format in room");
                throw new ServletException("Bad room number");
            }
        }
        if ((student = (StudentBean)request.getSession().getAttribute("student")) == null) {
            student = new StudentBean();
        }
        if (roomNo != null) {
            student.setRoomNo(roomNo);
        }
        if (student.getRoomNo() > 0) {
            roomNo = student.getRoomNo();
        }
        request.getSession().setAttribute("student", (Object)student);
        List<String> allSizes = null;
        List<String> allToppings = null;
        try {
            allSizes = this.studentService.getSizeNames();
            allToppings = this.studentService.getToppingNames();
        }
        catch (Exception e) {
            System.out.println("exception in displayWelcome " + e);
            throw new ServletException("failed to access DB", (Throwable)e);
        }
        List<PizzaOrderData> report = null;
        Boolean hasBaked = false;
        try {
            System.out.println("in StudentWelcomeController pt B (isnull = " + (this.studentService == null));
            if (roomNo != null && roomNo > 0) {
                report = this.studentService.getOrderStatus(roomNo);
                System.out.println("report has " + report.size());
                if (report != null) {
                    for (PizzaOrderData order : report) {
                        if (order.getStatus() != 2) continue;
                        hasBaked = true;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("in StudentController.displayWelcome");
            System.out.println(PizzaSystemConfig.exceptionReport(e));
            throw new ServletException("failed to access DB for order status", (Throwable)e);
        }
        request.setAttribute("statusReport", report);
        model.addAttribute("allSizes", allSizes);
        model.addAttribute("allToppings", allToppings);
        model.addAttribute("hasBaked", (Object)hasBaked);
        model.addAttribute("numRooms", (Object)10);
        model.addAttribute("statusReport", report);
        return "jsp/studentWelcome";
    }

    @RequestMapping(value={"orderForm.html"})
    public String displayOrderForm(Model model) throws ServletException {
        List<String> allSizes = null;
        List<String> allToppings = null;
        try {
            allSizes = this.studentService.getSizeNames();
            allToppings = this.studentService.getToppingNames();
        }
        catch (Exception e) {
            System.out.println("exception in displayWelcome " + e);
            throw new ServletException("failed to access DB for names, toppings", (Throwable)e);
        }
        System.out.println("#sizes = " + allSizes.size());
        model.addAttribute("allSizes", allSizes);
        model.addAttribute("allToppings", allToppings);
        model.addAttribute("numRooms", (Object)10);
        return "jsp/orderForm";
    }

    @RequestMapping(value={"orderPizza.html"})
    public String orderPizza(Model model, @RequestParam(value="size", required=false) String chosenSize, @RequestParam(value="room", required=false) String chosenRoom, @RequestParam(required=false) List<String> toppings, HttpServletRequest request) throws ServletException {
        String forwardURL;
        List<String> allToppings;
        List<String> allSizes;
        System.out.println("Starting orderPizza");
        String viewSuccess = "redirect:studentWelcome.html";
        String redoFormURL = "forward:/orderForm.html";
        System.out.println("in OrderPizzaController");
        String errorMessage = "";
        try {
            allSizes = this.studentService.getSizeNames();
            allToppings = this.studentService.getToppingNames();
            model.addAttribute("allSizes", allSizes);
            model.addAttribute("allToppings", allToppings);
        }
        catch (ServiceException e) {
            System.out.println("failed to access DB for names, toppings");
            throw new ServletException("failed to access DB for names, toppings", (Throwable)e);
        }
        if (allSizes.size() == 0) {
            errorMessage = errorMessage + "No pizza sizes are now available, please try again later";
        } else if (allToppings.size() == 0) {
            errorMessage = errorMessage + "No toppings are now available, please try again later";
        }
        if (errorMessage.length() > 0) {
            model.addAttribute("errorMessage", (Object)errorMessage);
            String forwardURL2 = redoFormURL;
            return forwardURL2;
        }
        if (chosenSize == null) {
            errorMessage = "Please choose a pizza size. ";
        }
        if (toppings == null || toppings.size() == 0) {
            errorMessage = errorMessage + "Please choose at least one topping. ";
        } else {
            System.out.println("#toppings from form: " + toppings.size());
        }
        if (errorMessage.length() > 0) {
            model.addAttribute("errorMessage", (Object)errorMessage);
            forwardURL = redoFormURL;
        } else {
            StudentBean student = (StudentBean)request.getSession().getAttribute("student");
            if (student == null) {
                return "forward:studentWelcome.html";
            }
            Integer roomNo = student.getRoomNo();
            if (chosenRoom != null) {
                roomNo = Integer.parseInt(chosenRoom);
                student.setRoomNo(roomNo);
            }
            if ((roomNo = Integer.valueOf(student.getRoomNo())) < 0) {
                System.out.println("OrderPizzaController: unexpected bad roomNo " + roomNo);
                throw new ServletException("unexpected bad roomNo");
            }
            try {
                this.studentService.makeOrder(roomNo, chosenSize, toppings);
                forwardURL = viewSuccess;
            }
            catch (ServiceException e) {
                System.out.println("OrderPizzaController: order failed: " + e + e.getCause());
                errorMessage = "Your order failed, please try again. " + e + e.getCause();
                model.addAttribute("errorMessage", (Object)errorMessage);
                forwardURL = redoFormURL;
            }
        }
        System.out.println("forwarding to " + forwardURL);
        return forwardURL;
    }

    @RequestMapping(value={"orderReceive.html"})
    public String receivePizza(Model model, HttpServletRequest request) throws ServletException {
        System.out.println("in receivePizza");
        HttpSession session = request.getSession();
        StudentBean student = (StudentBean)session.getAttribute("student");
        Integer roomNo = student.getRoomNo();
        System.out.println("in orderReceive, roomNo = " + roomNo);
        if (roomNo == null || roomNo == 0) {
            System.out.println("OrderStatus Controller: no room number in receive info ");
        }
        try {
            this.studentService.receiveOrders(roomNo);
        }
        catch (ServiceException e) {
            System.out.println("Exception in receivePizza Controller: " + e);
        }
        return "forward:studentWelcome.html";
    }
}

