/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.datasource.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.PooledConnection;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.datasource.OraclePooledConnection;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.datasource.impl.OraclePooledConnectionBuilderImpl;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements oracle.jdbc.datasource.OracleConnectionPoolDataSource,
oracle.jdbc.replay.internal.OracleConnectionPoolDataSource {
    public OracleConnectionPoolDataSource() throws SQLException {
        this.dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String localUser = null;
        OpaqueString localPassword = OpaqueString.NULL;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            localUser = this.user;
            localPassword = this.password != null ? this.password : OpaqueString.NULL;
        }
        return this.getPooledConnection(localUser, localPassword);
    }

    @Override
    public PooledConnection getPooledConnection(String _user, @Blind String _password) throws SQLException {
        return this.getPooledConnection(_user, OpaqueString.newOpaqueString(_password));
    }

    private PooledConnection getPooledConnection(String _user, OpaqueString _password) throws SQLException {
        Connection conn = this.getPhysicalConnection(_user, _password);
        oracle.jdbc.pool.OraclePooledConnection opc = new oracle.jdbc.pool.OraclePooledConnection(conn);
        return opc;
    }

    PooledConnection getPooledConnection(@Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties prop) throws SQLException {
        Connection conn = this.getPhysicalConnection(prop, null);
        oracle.jdbc.pool.OraclePooledConnection opc = new oracle.jdbc.pool.OraclePooledConnection(conn);
        return opc;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.user, this.password);
    }

    protected Connection getPhysicalConnection(String _url, String _user, @Blind String _passwd) throws SQLException {
        this.url = _url;
        return super.getConnection(_user, OpaqueString.newOpaqueString(_passwd));
    }

    protected Connection getPhysicalConnection(String _user, @Blind String _passwd) throws SQLException {
        return super.getConnection(_user, OpaqueString.newOpaqueString(_passwd));
    }

    protected Connection getPhysicalConnection(String _url, String _user, OpaqueString _passwd) throws SQLException {
        this.url = _url;
        return super.getConnection(_user, _passwd);
    }

    protected Connection getPhysicalConnection(String _user, OpaqueString _passwd) throws SQLException {
        return super.getConnection(_user, _passwd);
    }

    protected oracle.jdbc.pool.OraclePooledConnection getPooledConnection(OracleConnectionBuilderImpl connBuilder) throws SQLException {
        Connection conn = super.getConnection(connBuilder);
        oracle.jdbc.pool.OraclePooledConnection opc = new oracle.jdbc.pool.OraclePooledConnection(conn);
        return opc;
    }

    @Override
    public OraclePooledConnectionBuilder createPooledConnectionBuilder() throws SQLException {
        return new OraclePooledConnectionBuilderImpl(){

            @Override
            public OraclePooledConnection build() throws SQLException {
                OracleConnectionBuilderImpl connBldr = (OracleConnectionBuilderImpl)OracleConnectionPoolDataSource.this.createConnectionBuilder().copy(this);
                connBldr.verifyBuildConfiguration();
                return OracleConnectionPoolDataSource.this.getPooledConnection(connBldr);
            }
        };
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    @Override
    public Connection getConnection(String usr, String pwd) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }

    public Connection getConnection(@Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties props) throws SQLException {
        throw DatabaseError.createSqlException(23);
    }
}

