/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;

public class ClosureOpt
implements LargeItemsetsFinder {
    private static final int INITIAL_CAPACITY = 10000;
    private Vector candidates;
    private Vector k_frequent;
    private Vector large;
    private long[][] counts;
    private HashTree ht_candidates;
    private HashTree ht_k_frequent;
    private int pass_num;
    private int step;
    private DBReader db_reader;
    private DBCacheWriter cache_writer;
    private long num_rows;
    private int num_cols;
    private long min_weight;

    private void evaluateCandidates() {
        int n = 0;
        while (n < this.candidates.size()) {
            Itemset itemset = (Itemset)this.candidates.get(n);
            if (itemset.getWeight() >= this.min_weight) {
                itemset.setSupport((float)itemset.getWeight() / (float)this.num_rows);
                try {
                    if (this.cache_writer != null) {
                        this.cache_writer.writeItemset(itemset);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Fishy error!!!\n" + iOException);
                }
                this.large.add(itemset);
                int n2 = itemset.getItem(itemset.size() - 1) + 1;
                while (n2 <= this.num_cols) {
                    if (this.counts[n][n2 - 1] >= this.min_weight) {
                        Itemset itemset2 = new Itemset(itemset);
                        itemset2.addItem(n2);
                        itemset2.setWeight(this.counts[n][n2 - 1]);
                        itemset2.setSupport((float)itemset2.getWeight() / (float)this.num_rows);
                        try {
                            if (this.cache_writer != null) {
                                this.cache_writer.writeItemset(itemset2);
                            }
                        }
                        catch (IOException iOException) {
                            System.err.println("Fishy error!!!\n" + iOException);
                        }
                        this.large.add(itemset2);
                        this.k_frequent.add(itemset2);
                        this.ht_k_frequent.add(this.k_frequent.size() - 1);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.candidates.clear();
        this.ht_candidates = new HashTree(this.candidates);
    }

    public int findLargeItemsets(DBReader dBReader, DBCacheWriter dBCacheWriter, float f) {
        this.db_reader = dBReader;
        this.cache_writer = dBCacheWriter;
        this.num_rows = dBReader.getNumRows();
        this.num_cols = (int)dBReader.getNumColumns();
        this.min_weight = (long)((float)this.num_rows * f);
        this.candidates = new Vector(10000);
        this.k_frequent = new Vector(10000);
        this.large = new Vector(10000);
        this.ht_k_frequent = new HashTree(this.k_frequent);
        int n = 1;
        while (n <= this.num_cols) {
            Itemset itemset = new Itemset(1);
            itemset.addItem(n);
            this.candidates.add(itemset);
            ++n;
        }
        this.step = 1;
        this.pass_num = 1;
        while (true) {
            this.counts = new long[this.candidates.size()][this.num_cols];
            if (this.step == 1) {
                this.weighCandidatesWithoutHashTree();
            } else {
                this.weighCandidates();
            }
            this.evaluateCandidates();
            ++this.step;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.large.size()) {
                int n4 = ((Itemset)this.large.get(n3)).size();
                if (n4 > n2) {
                    n2 = n4;
                }
                ++n3;
            }
            if (this.step > n2 || (long)this.step >= this.db_reader.getNumColumns()) break;
            this.generateCandidates();
            if (this.candidates.size() == 0) break;
            ++this.step;
            ++this.pass_num;
        }
        return this.pass_num;
    }

    private void generateCandidates() {
        this.ht_k_frequent.prepareForDescent();
        if (this.k_frequent.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.k_frequent.size() - 1) {
            int n2 = n + 1;
            while (n2 < this.k_frequent.size()) {
                if (!this.getCandidate(n, n2)) break;
                ++n2;
            }
            ++n;
        }
        this.k_frequent.clear();
        this.ht_k_frequent = new HashTree(this.k_frequent);
    }

    private boolean getCandidate(int n, int n2) {
        Itemset itemset;
        Itemset itemset2 = (Itemset)this.k_frequent.get(n);
        if (!itemset2.canCombineWith(itemset = (Itemset)this.k_frequent.get(n2))) {
            return false;
        }
        Itemset itemset3 = itemset2.combineWith(itemset);
        if (this.ht_k_frequent.countSubsets(itemset3) == (long)itemset3.size()) {
            this.candidates.add(itemset3);
            this.ht_candidates.add(this.candidates.size() - 1);
        }
        return true;
    }

    private void weighCandidates() {
        this.ht_candidates.prepareForDescent();
        try {
            Itemset itemset = this.db_reader.getFirstRow();
            this.ht_candidates.update(itemset, this.counts);
            while (this.db_reader.hasMoreRows()) {
                itemset = this.db_reader.getNextRow();
                this.ht_candidates.update(itemset, this.counts);
            }
        }
        catch (Exception exception) {
            System.err.println("Error scanning database!!!\n" + exception);
        }
    }

    private void weighCandidatesWithoutHashTree() {
        try {
            int n;
            Itemset itemset = this.db_reader.getFirstRow();
            int n2 = 0;
            while (n2 < itemset.size()) {
                n = 0;
                while (n < itemset.size()) {
                    long[] lArray = this.counts[itemset.getItem(n2) - 1];
                    int n3 = itemset.getItem(n) - 1;
                    lArray[n3] = lArray[n3] + 1L;
                    ++n;
                }
                ++n2;
            }
            while (this.db_reader.hasMoreRows()) {
                itemset = this.db_reader.getNextRow();
                n = 0;
                while (n < itemset.size()) {
                    int n4 = 0;
                    while (n4 < itemset.size()) {
                        long[] lArray = this.counts[itemset.getItem(n) - 1];
                        int n5 = itemset.getItem(n4) - 1;
                        lArray[n5] = lArray[n5] + 1L;
                        ++n4;
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < this.candidates.size()) {
                ((Itemset)this.candidates.get(n)).setWeight(this.counts[n][n]);
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Error scanning database!!!\n" + exception);
        }
    }
}

