/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FPgrowth
implements LargeItemsetsFinder {
    private DBReader db_reader;
    private DBCacheWriter cache_writer;
    private long num_rows;
    private int num_cols;
    private long min_weight;
    private int[] counts;
    private int pass_num;

    private FPTree constructFPTree() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.counts.length) {
            if ((long)this.counts[n2] >= this.min_weight) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Item[n];
        int n3 = 1;
        int n4 = 0;
        while (n3 < this.counts.length) {
            if ((long)this.counts[n3] >= this.min_weight) {
                objectArray[n4++] = new Item(n3, this.counts[n3]);
            }
            ++n3;
        }
        Arrays.sort(objectArray);
        int[] nArray = new int[n];
        int n5 = 0;
        while (n5 < n) {
            nArray[n5] = ((Item)objectArray[n - n5 - 1]).item;
            ++n5;
        }
        FPTree fPTree = new FPTree(nArray, this.num_rows, this.min_weight, this.cache_writer);
        try {
            Itemset itemset = this.db_reader.getFirstRow();
            this.processRow(itemset, fPTree);
            while (this.db_reader.hasMoreRows()) {
                itemset = this.db_reader.getNextRow();
                this.processRow(itemset, fPTree);
            }
        }
        catch (Exception exception) {
            System.err.println("Error scanning database!!!\n" + exception);
        }
        ++this.pass_num;
        return fPTree;
    }

    private void countItemOccurrences() {
        this.counts = new int[this.num_cols + 1];
        try {
            Itemset itemset = this.db_reader.getFirstRow();
            int n = 0;
            while (n < itemset.size()) {
                int n2 = itemset.getItem(n);
                this.counts[n2] = this.counts[n2] + 1;
                ++n;
            }
            while (this.db_reader.hasMoreRows()) {
                itemset = this.db_reader.getNextRow();
                int n3 = 0;
                while (n3 < itemset.size()) {
                    int n4 = itemset.getItem(n3);
                    this.counts[n4] = this.counts[n4] + 1;
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error scanning database!!!\n" + exception);
        }
        ++this.pass_num;
    }

    public int findLargeItemsets(DBReader dBReader, DBCacheWriter dBCacheWriter, float f) {
        this.db_reader = dBReader;
        this.cache_writer = dBCacheWriter;
        this.num_rows = dBReader.getNumRows();
        this.num_cols = (int)this.db_reader.getNumColumns();
        this.min_weight = (long)((float)this.num_rows * f);
        this.countItemOccurrences();
        FPTree fPTree = this.constructFPTree();
        if (fPTree != null) {
            System.out.println("<FPgrowth>: FPTree has " + fPTree.count_nodes + " nodes");
            fPTree.fp_growth(new Itemset());
        } else {
            System.out.println("<FPgrowth>: FPTree is empty");
        }
        return this.pass_num;
    }

    private void processRow(Itemset itemset, FPTree fPTree) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n2 < itemset.size()) {
            n = itemset.getItem(n2);
            if ((long)this.counts[n] >= this.min_weight) {
                ++n3;
            }
            ++n2;
        }
        if (n3 > 0) {
            Object[] objectArray = new Item[n3];
            n2 = 0;
            int n4 = 0;
            while (n2 < itemset.size()) {
                n = itemset.getItem(n2);
                if ((long)this.counts[n] >= this.min_weight) {
                    objectArray[n4++] = new Item(n, this.counts[n]);
                }
                ++n2;
            }
            Arrays.sort(objectArray);
            int[] nArray = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                nArray[n2] = ((Item)objectArray[n3 - n2 - 1]).item;
                ++n2;
            }
            fPTree.insert(nArray, 1);
        }
    }

    private static class FPTreeNode {
        public int item;
        public int count;
        public int seq_num;
        public int header_index;
        public FPTreeNode parent;
        public FPTreeNode child;
        public FPTreeNode sibling;
        public FPTreeNode next;

        public FPTreeNode() {
        }

        public FPTreeNode(int n, int n2, int n3, int n4, FPTreeNode fPTreeNode, FPTreeNode fPTreeNode2, FPTreeNode fPTreeNode3) {
            this.item = n;
            this.count = n2;
            this.seq_num = n3;
            this.header_index = n4;
            this.parent = fPTreeNode;
            this.sibling = fPTreeNode2;
            this.next = fPTreeNode3;
        }
    }

    private static class FPTreeHeaderEntry {
        public int item;
        public int count;
        public FPTreeNode head;

        public FPTreeHeaderEntry() {
        }

        public FPTreeHeaderEntry(int n) {
            this.item = n;
        }
    }

    private static class FPTree {
        public FPTreeHeaderEntry[] header;
        public FPTreeNode root;
        public Map item2index;
        public boolean hasMultiplePaths;
        public int count_nodes;
        public long num_rows;
        public long min_weight;
        public DBCacheWriter cache_writer;

        public FPTree(int[] nArray, long l, long l2, DBCacheWriter dBCacheWriter) {
            this.header = new FPTreeHeaderEntry[nArray.length];
            this.root = new FPTreeNode();
            this.item2index = new HashMap(nArray.length);
            this.num_rows = l;
            this.min_weight = l2;
            this.cache_writer = dBCacheWriter;
            int n = 0;
            while (n < nArray.length) {
                this.header[n] = new FPTreeHeaderEntry(nArray[n]);
                this.item2index.put(new Integer(nArray[n]), new Integer(n));
                ++n;
            }
        }

        private FPTree buildConditionalFPTree(int n) {
            int n2 = (Integer)this.item2index.get(new Integer(n));
            int[] nArray = new int[n2];
            FPTreeNode fPTreeNode = this.header[n2].head;
            while (fPTreeNode != null) {
                FPTreeNode fPTreeNode2 = fPTreeNode.parent;
                while (fPTreeNode2 != this.root) {
                    int n3 = fPTreeNode2.header_index;
                    nArray[n3] = nArray[n3] + fPTreeNode.count;
                    fPTreeNode2 = fPTreeNode2.parent;
                }
                fPTreeNode = fPTreeNode.next;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < nArray.length) {
                if ((long)nArray[n5] >= this.min_weight) {
                    ++n4;
                }
                ++n5;
            }
            if (n4 == 0) {
                return null;
            }
            Object[] objectArray = new Item[n4];
            int n6 = 0;
            int n7 = 0;
            while (n6 < nArray.length) {
                if ((long)nArray[n6] >= this.min_weight) {
                    objectArray[n7++] = new Item(this.header[n6].item, nArray[n6]);
                }
                ++n6;
            }
            Arrays.sort(objectArray);
            int[] nArray2 = new int[n4];
            int n8 = 0;
            while (n8 < n4) {
                nArray2[n8] = ((Item)objectArray[n4 - n8 - 1]).item;
                ++n8;
            }
            FPTree fPTree = new FPTree(nArray2, this.num_rows, this.min_weight, this.cache_writer);
            FPTreeNode fPTreeNode3 = this.header[n2].head;
            while (fPTreeNode3 != null) {
                if (fPTreeNode3.parent != this.root) {
                    int n9 = fPTreeNode3.parent.seq_num;
                    Item[] itemArray = new Item[n9];
                    FPTreeNode fPTreeNode4 = fPTreeNode3.parent;
                    while (fPTreeNode4 != this.root) {
                        itemArray[--n9] = new Item(fPTreeNode4.item, fPTreeNode4.header_index);
                        fPTreeNode4 = fPTreeNode4.parent;
                    }
                    this.processPattern(itemArray, fPTreeNode3.count, fPTree, nArray);
                }
                fPTreeNode3 = fPTreeNode3.next;
            }
            return fPTree;
        }

        private void combine(int[] nArray, Itemset itemset) {
            int n = 0;
            while (n < nArray.length) {
                Itemset itemset2 = new Itemset(itemset);
                itemset2.addItem(nArray[n]);
                int n2 = this.header[this.header.length - n - 1].count;
                itemset2.setWeight((long)n2);
                itemset2.setSupport((float)n2 / (float)this.num_rows);
                try {
                    if (this.cache_writer != null) {
                        this.cache_writer.writeItemset(itemset2);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("I/O error!!!\n" + iOException);
                }
                this.combine(nArray, itemset2, n + 1);
                ++n;
            }
        }

        private void combine(int[] nArray, Itemset itemset, int n) {
            int n2 = n;
            while (n2 < nArray.length) {
                Itemset itemset2 = new Itemset(itemset);
                itemset2.addItem(nArray[n2]);
                try {
                    if (this.cache_writer != null) {
                        this.cache_writer.writeItemset(itemset2);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("I/O error!!!\n" + iOException);
                }
                this.combine(nArray, itemset2, n2 + 1);
                ++n2;
            }
        }

        public void fp_growth(Itemset itemset) {
            if (!this.hasMultiplePaths) {
                int[] nArray = new int[this.header.length];
                int n = 0;
                while (n < this.header.length) {
                    nArray[this.header.length - n - 1] = this.header[n].item;
                    ++n;
                }
                this.combine(nArray, itemset);
            } else {
                int n = this.header.length - 1;
                while (n >= 0) {
                    FPTree fPTree;
                    Itemset itemset2 = new Itemset(itemset);
                    itemset2.addItem(this.header[n].item);
                    itemset2.setWeight((long)this.header[n].count);
                    itemset2.setSupport((float)this.header[n].count / (float)this.num_rows);
                    try {
                        if (this.cache_writer != null) {
                            this.cache_writer.writeItemset(itemset2);
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println("I/O error!!!\n" + iOException);
                    }
                    if ((fPTree = this.buildConditionalFPTree(this.header[n].item)) != null) {
                        fPTree.fp_growth(itemset2);
                    }
                    --n;
                }
            }
        }

        public void insert(int[] nArray, int n) {
            FPTreeNode fPTreeNode = this.root;
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = (Integer)this.item2index.get(new Integer(nArray[n2]));
                this.header[n3].count += n;
                FPTreeNode fPTreeNode2 = fPTreeNode.child;
                while (fPTreeNode2 != null) {
                    if (fPTreeNode2.item == nArray[n2]) break;
                    fPTreeNode2 = fPTreeNode2.sibling;
                }
                if (fPTreeNode2 == null) {
                    FPTreeNode fPTreeNode3;
                    if (fPTreeNode.child != null) {
                        this.hasMultiplePaths = true;
                    }
                    ++this.count_nodes;
                    this.header[n3].head = fPTreeNode3 = new FPTreeNode(nArray[n2], n, n2 + 1, n3, fPTreeNode, fPTreeNode.child, this.header[n3].head);
                    fPTreeNode.child = fPTreeNode3;
                    fPTreeNode = fPTreeNode3;
                } else {
                    fPTreeNode2.count += n;
                    fPTreeNode = fPTreeNode2;
                }
                ++n2;
            }
        }

        private void processPattern(Item[] itemArray, int n, FPTree fPTree, int[] nArray) {
            Item item;
            int n2 = 0;
            int n3 = 0;
            while (n2 < itemArray.length) {
                item = itemArray[n2];
                if ((long)nArray[item.count] >= this.min_weight) {
                    ++n3;
                }
                ++n2;
            }
            if (n3 > 0) {
                Object[] objectArray = new Item[n3];
                n2 = 0;
                int n4 = 0;
                while (n2 < itemArray.length) {
                    item = itemArray[n2];
                    if ((long)nArray[item.count] >= this.min_weight) {
                        objectArray[n4++] = new Item(item.item, nArray[item.count]);
                    }
                    ++n2;
                }
                Arrays.sort(objectArray);
                int[] nArray2 = new int[n3];
                n2 = 0;
                while (n2 < n3) {
                    nArray2[n2] = ((Item)objectArray[n3 - n2 - 1]).item;
                    ++n2;
                }
                fPTree.insert(nArray2, n);
            }
        }
    }

    private static class Item
    implements Comparable {
        public int item;
        public int count;

        public Item(int n, int n2) {
            this.item = n;
            this.count = n2;
        }

        public int compareTo(Object object) {
            Item item = (Item)object;
            return this.count - item.count;
        }

        public String toString() {
            return "<" + this.item + ", " + this.count + ">";
        }
    }
}

